% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_4.R
\docType{class}
\name{biomod2_model}
\alias{biomod2_model}
\alias{biomod2_model-class}
\alias{ANN_biomod2_model-class}
\alias{CTA_biomod2_model-class}
\alias{FDA_biomod2_model-class}
\alias{GAM_biomod2_model-class}
\alias{GBM_biomod2_model-class}
\alias{GLM_biomod2_model-class}
\alias{MARS_biomod2_model-class}
\alias{MAXENT_biomod2_model-class}
\alias{MAXNET_biomod2_model-class}
\alias{RF_biomod2_model-class}
\alias{SRE_biomod2_model-class}
\alias{XGBOOST_biomod2_model-class}
\alias{show,biomod2_model-method}
\title{Single model output object class (when running \code{BIOMOD_Modeling()})}
\usage{
\S4method{show}{biomod2_model}(object)
}
\arguments{
\item{object}{a \code{\link{biomod2_model}} object}
}
\description{
Class created by \code{\link{BIOMOD_Modeling}} and \code{\link{bm_RunModel}}
}
\details{
\code{biomod2_model} is the basic object for \pkg{biomod2} single species distribution models. 
\cr All listed classes below are derived from \code{biomod2_model}, and have a 
\code{model_class} slot specific value :

\itemize{
  \item \code{ANN_biomod2_model} : \code{model_class} is \code{ANN}
  \item \code{CTA_biomod2_model} : \code{model_class} is \code{CTA}
  \item \code{FDA_biomod2_model} : \code{model_class} is \code{FDA}
  \item \code{GBM_biomod2_model} : \code{model_class} is \code{GBM}
  \item \code{GLM_biomod2_model} : \code{model_class} is \code{GLM}
  \item \code{MARS_biomod2_model} : \code{model_class} is \code{MARS}
  \item \code{MAXENT_biomod2_model} : \code{model_class} is \code{MAXENT}
  \item \code{MAXNET_biomod2_model} : \code{model_class} is 
  \code{MAXNET}
  \item \code{RF_biomod2_model} : \code{model_class} is \code{RF}
  \item \code{SRE_biomod2_model} : \code{model_class} is \code{SRE}
}
}
\section{Slots}{

\describe{
\item{\code{model_name}}{a \code{character} corresponding to the model name}

\item{\code{model_class}}{a \code{character} corresponding to the model class}

\item{\code{model_options}}{a \code{list} containing the model options}

\item{\code{model}}{the corresponding model object}

\item{\code{scaling_model}}{the corresponding scaled model object}

\item{\code{dir_name}}{a \code{character} corresponding to the modeling folder}

\item{\code{resp_name}}{a \code{character} corresponding to the species name}

\item{\code{expl_var_names}}{a \code{vector} containing names of explanatory variables}

\item{\code{expl_var_type}}{a \code{vector} containing classes of explanatory variables}

\item{\code{expl_var_range}}{a \code{list} containing ranges of explanatory variables}

\item{\code{model_evaluation}}{a \code{data.frame} containing the model evaluations}

\item{\code{model_variables_importance}}{a \code{data.frame} containing the model variables importance}
}}

\examples{

showClass("biomod2_model")
showClass("ANN_biomod2_model")
showClass("CTA_biomod2_model")
showClass("FDA_biomod2_model")
showClass("GAM_biomod2_model")
showClass("GBM_biomod2_model")
showClass("GLM_biomod2_model")
showClass("MARS_biomod2_model")
showClass("MAXENT_biomod2_model")
showClass("MAXNET_biomod2_model")
showClass("RF_biomod2_model")
showClass("SRE_biomod2_model")

}
\seealso{
\code{\link{BIOMOD_Modeling}}, \code{\link{bm_RunModel}}

Other Toolbox objects: 
\code{\link{BIOMOD.ensemble.models.out}},
\code{\link{BIOMOD.formated.data}},
\code{\link{BIOMOD.formated.data.PA}},
\code{\link{BIOMOD.models.options}},
\code{\link{BIOMOD.models.out}},
\code{\link{BIOMOD.options.dataset}},
\code{\link{BIOMOD.options.default}},
\code{\link{BIOMOD.projection.out}},
\code{\link{BIOMOD.stored.data}},
\code{\link{biomod2_ensemble_model}}
}
\author{
Damien Georges
}
\concept{Toolbox objects}
