% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_MCMC.R
\name{predict_inactivation_MCMC}
\alias{predict_inactivation_MCMC}
\title{Dynamic Prediction Intervals from a Monte Carlo Adjustment}
\usage{
predict_inactivation_MCMC(fit_object, temp_profile, n_simulations = 100,
  times = NULL, quantiles = c(2.5, 97.5), additional_pars = NULL)
}
\arguments{
\item{fit_object}{An object of classes \code{FitInactivationMCMC},
\code{IsoFitInactivation} or \code{FitInactivation}.}

\item{temp_profile}{data frame with discrete values of the temperature for
each time. It must have one column named \code{time} and another named
\code{temperature} providing discrete values of the temperature at
time points.}

\item{n_simulations}{a numeric indicating how many Monte Carlo simulations
to perform. \code{100} by default.}

\item{times}{numeric vector specifying the time points when results are
desired. If \code{NULL}, the times in \code{MCMC_fit$best_prediction}
are used. \code{NULL} by default.}

\item{quantiles}{numeric vector indicating the quantiles to calculate in
percentage. By default, it is set to c(2.5, 97.5) which generates a
prediction interval with confidence 0.95. If \code{NULL}, the quantiles
are not calculated and all the simulations are returned.}

\item{additional_pars}{Additional parameters not included in the adjustment (e.g.
the initial number of microorganism in an isothermal fit).}
}
\value{
A data frame of class \code{PredInactivationMCMC}. On its first column,
        time at which the calculation has been made is indicated.
        If \code{quantiles = NULL}, the following columns contain the
        results of each simulation. Otherwise, the second and third columns
        provide the mean and median of the simulations at the given time
        point. Following columns contain the quantiles of the results.
}
\description{
Given a model adjustment of a dynamic microbial inactivation process
performed using any of the functions in \code{bioinactivation} calculates
probability intervals at each time point using a Monte Carlo method.
}

