% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/geeraerd_model.R
\name{dGeeraerd_model}
\alias{dGeeraerd_model}
\title{First Derivate of Geeraerd's Model}
\usage{
dGeeraerd_model(t, x, parms, temp_profile)
}
\arguments{
\item{t}{numeric vector indicating the time of the experiment.}

\item{x}{list with the values of the variables at time \eqn{t}.}

\item{parms}{parameters for the secondary model. No explicit check of their
validity is performed (see section \bold{Model Parameters}).}

\item{temp_profile}{a function that provides the temperature at a given time.}
}
\value{
A list with the value of the first derivatives of N and C_c at time
        \code{t}.
}
\description{
Calculates the first derivative of the Geeraerd's model at a given time for
the model parameters provided and the environmental conditions given.
}
\details{
This function is compatible with the function
\code{\link{predict_inactivation}}.
}
\section{Model Equation}{

     \deqn{\frac{dN}{dt} = -N \cdot k_{max} \cdot \alpha \cdot \gamma}{
           dN/dt = - N * k_max * \alpha * \gamma}

     \deqn{\frac{dC_c}{dt} = - C_c \cdot k_{max}}{
           dC_c/dt = - C_c * k_max}

     \deqn{\alpha = \frac {1}{1+C_c}}{
           \alpha = 1/(1+C_c)}

     \deqn{\gamma = 1 - \frac{N_{res}}{N}}{
           \gamma = 1 - N_res/N}

     \deqn{k_{max} = \frac{1}{D_T}}{k_max = 1/D_T}

     \deqn{log_{10}D_T = log_{10}D_R + \frac{T_R-T}{z}}{
            log(D_T) = log(D_R) + (T_R-T)/z}
}

\section{Model Parameters}{

     \itemize{
         \item temp_ref: Reference temperature for the calculation,
         \item D_R: D-value at the reference temperature,
         \item z: z value,
         \item N_min: Minimum value of N (defines the tail).
         }
}

\section{Notes}{

     To define the Geeraerd model without tail, assign \code{N_min = 0}.
     For the model without shoulder, assign \code{C_0 = 0}
}
\seealso{
\code{\link{predict_inactivation}}
}

