% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SecondaryGrowthComparison_class.R
\name{SecondaryComparison}
\alias{SecondaryComparison}
\alias{coef.SecondaryComparison}
\alias{summary.SecondaryComparison}
\alias{print.SecondaryComparison}
\alias{plot.SecondaryComparison}
\title{SecondaryComparison class}
\usage{
\method{coef}{SecondaryComparison}(object, ...)

\method{summary}{SecondaryComparison}(object, ...)

\method{print}{SecondaryComparison}(x, ...)

\method{plot}{SecondaryComparison}(x, y, ..., type = 1, add_trend = TRUE)
}
\arguments{
\item{object}{an instance of SecondaryComparison}

\item{...}{ignored}

\item{x}{an instance of SecondaryComparison}

\item{y}{ignored}

\item{type}{if type==1, the plot compares the model predictions. If type ==2,
the plot compares the parameter estimates.}

\item{add_trend}{should a trend line of the residuals be added for type==3? \code{TRUE}
by default}
}
\description{
The \code{SecondaryComparison} class contains several functions for model comparison
and model selection of growth models. It should not be instanced directly. Instead,
it should be constructed using \code{\link[=compare_secondary_fits]{compare_secondary_fits()}}.

It includes two type of tools for model selection and comparison: statistical indexes
and visual analyses. Please check the sections below for details.

Note that all these tools use the names defined in \code{\link[=compare_secondary_fits]{compare_secondary_fits()}}, so
we recommend passing a named list to that function.
}
\section{Functions}{
\itemize{
\item \code{coef.SecondaryComparison}: table of parameter estimates

\item \code{summary.SecondaryComparison}: summary table for the comparison

\item \code{print.SecondaryComparison}: print of the model comparison

\item \code{plot.SecondaryComparison}: illustrations comparing the fitted models
}}

\section{Statistical indexes}{

\code{SecondaryComparison} implements two S3 methods to obtain numerical values to facilitate
model comparison and selection.
\itemize{
\item the \code{coef} method returns a tibble with the values of the parameter estimates
and their corresponding standard errors for each model.
\item the \code{summary} returns a tibble with the AIC, number of degrees of freedom,
mean error and root mean squared error for each model.
}
}

\section{Visual analyses}{

The S3 plot method can generate three types of plots:
\itemize{
\item when \code{type = 1}, the plot compares the observations against the model predictions
for each model. The plot includes a linear model fitted to the residuals. In the case
of a perfect fit, the line would have slope=1 and intercept=0 (shown as a black, dashed line).
\item when \code{type = 2}, the plot compares the parameter estimates using error bars, where
the limits of the error bars are the expected value +/- one standard error. In case
one model does not has some model parameter (i.e. either because it is not defined
or because it was fixed), the parameter is not included in the plot.
}
}

