% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompareIsoGrowth_class.R
\name{GrowthComparison}
\alias{GrowthComparison}
\alias{plot.GrowthComparison}
\alias{coef.GrowthComparison}
\alias{print.GrowthComparison}
\alias{summary.GrowthComparison}
\title{GrowthComparison class}
\usage{
\method{plot}{GrowthComparison}(x, y, ..., type = 1, add_trend = TRUE)

\method{coef}{GrowthComparison}(object, ...)

\method{print}{GrowthComparison}(x, ...)

\method{summary}{GrowthComparison}(object, ...)
}
\arguments{
\item{x}{an instance of \link{GrowthComparison}}

\item{y}{ignored}

\item{...}{ignored}

\item{type}{if type==1, the plot compares the model predictions. If type ==2,
the plot compares the parameter estimates. If type==3, the plot shows the residuals}

\item{add_trend}{should a trend line of the residuals be added for type==3? \code{TRUE}
by default}

\item{object}{an instance of \link{GrowthComparison}}
}
\description{
The \code{GrowthComparison} class contains several functions for model comparison
and model selection of growth models. It should not be instanced directly. Instead,
it should be constructed using \code{\link[=compare_growth_fits]{compare_growth_fits()}}.

It includes two type of tools for model selection and comparison: statistical indexes
and visual analyses. Please check the sections below for details.

Note that all these tools use the names defined in \code{\link[=compare_growth_fits]{compare_growth_fits()}}, so
we recommend passing a named list to that function.
}
\section{Functions}{
\itemize{
\item \code{plot.GrowthComparison}: illustrations comparing the fitted models

\item \code{coef.GrowthComparison}: table of parameter estimates

\item \code{print.GrowthComparison}: print of the model comparison

\item \code{summary.GrowthComparison}: summary table for the comparison
}}

\section{Statistical indexes}{

\code{GrowthComparison} implements two S3 methods to obtain numerical values to facilitate
model comparison and selection.
\itemize{
\item the \code{coef} method returns a tibble with the values of the parameter estimates
and their corresponding standard errors for each model.
\item the \code{summary} returns a tibble with the AIC, number of degrees of freedom,
mean error and root mean squared error for each model.
}
}

\section{Visual analyses}{

The S3 plot method can generate three types of plots:
\itemize{
\item when \code{type = 1}, the plot compares the fitted growth curves against the
experimental data used to fit the model.
\item when \code{type = 2}, the plot compares the parameter estimates using error bars, where
the limits of the error bars are the expected value +/- one standard error. In case
one model does not have some model parameter (i.e. either because it is not defined
or because it was fixed), the parameter is not included in the plot.
\item when \code{type=3}, the plot shows the tendency of the residuals for each model. This
plot can be used to detect deviations from independence.
}
}

