% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_secondary_models.R
\name{calculate_gammas_secondary}
\alias{calculate_gammas_secondary}
\title{Gamma factors for fitting secondary models}
\usage{
calculate_gammas_secondary(sec_model_names, my_data, secondary_models)
}
\arguments{
\item{sec_model_names}{named character vector defining the type of secondary
model. Its names correspond to the environmental conditions and its values
define the corresponding type of secondary model.}

\item{my_data}{Tibble of experimental conditions.}

\item{secondary_models}{A list defining the parameters of the secondary models.}
}
\value{
a numeric vector of length \code{nrow(my_data)} with the gamma factor
for each experimental condition.
}
\description{
A helper for fitting the secondary gamma models.
Calculates the gamma factors corresponding to the models defined
and the experimental conditions. In order for it to work, the environmental
factors must be named identically in the 3 arguments.
}
