% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_MCMC_growth.R
\name{predict_MCMC_growth}
\alias{predict_MCMC_growth}
\title{Stochastic growth of MCMC fit}
\usage{
predict_MCMC_growth(MCMCfit, times, env_conditions, niter)
}
\arguments{
\item{MCMCfit}{An instance of \code{FitDynamicGrowthMCMC} or
\code{FitMultipleGrowthMCMC}.}

\item{times}{Numeric vector of storage times for the predictions.}

\item{env_conditions}{Tibble with the (dynamic) environmental conditions
during the experiment. It must have one column named 'time' with the
storage time and as many columns as required with the environmental conditions.}

\item{niter}{Number of iterations.}
}
\value{
A list of class \code{MCMCgrowth} with items:
\itemize{
\item sample: Parameter sample used for the calculations.
\item simulations: Individual growth curves calculated based on the parameter
sample.
\item quantiles: Tibble with the limits of the credible intervals
 (5%, 10%, 50%, 90% and 95%) for each time point.
\item model: Instance of \code{FitDynamicGrowthMCMC} used for predictions.
}
}
\description{
Makes a stochastic prediction of microbial growth based on a growth model
fitted using \code{\link{fit_MCMC_growth}} or \code{\link{fit_multiple_growth_MCMC}}.
This function predicts growth curves for \code{niter} samples (with replacement)
of the samples of the MCMC algorithm. Then, credible intervals are calculated based on the
quantiles of the model predictions at each time point.
}
\examples{
\donttest{
## We need a FitDynamicGrowthMCMC object

data("example_dynamic_growth")
data("example_env_conditions")

sec_model_names <- c(temperature = "CPM", aw= "CPM")

known_pars <- list(Nmax = 1e4,  # Primary model
    N0 = 1e0, Q0 = 1e-3,  # Initial values of the primary model
    mu_opt = 4, # mu_opt of the gamma model
    temperature_n = 1,  # Secondary model for temperature
    aw_xmax = 1, aw_xmin = .9, aw_n = 1  # Secondary model for water activity
    )

my_start <- list(temperature_xmin = 25, temperature_xopt = 35,
    temperature_xmax = 40,
    aw_xopt = .95)

set.seed(12124) # Setting seed for repeatability

my_MCMC_fit <- fit_MCMC_growth(example_dynamic_growth, example_env_conditions,
    my_start, known_pars, sec_model_names, niter = 3000)

## Define the conditions for the simulation

my_times <- seq(0, 15, length = 5)
niter <- 3000

my_MCMC_prediction <- predict_MCMC_growth(my_MCMC_fit,
    my_times,
    example_env_conditions, # It could be different from the one used for fitting
    niter)

plot(my_MCMC_prediction)
}

}
