% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beam.R
\name{beam_profile}
\alias{beam_profile}
\title{Calculate vertical radiation profile}
\usage{
beam_profile(
  height,
  distance,
  elev,
  antenna = 0,
  beam_angle = 1,
  k = 4/3,
  lat = 35,
  re = 6378,
  rp = 6357
)
}
\arguments{
\item{height}{Numeric. Height in m.}

\item{distance}{Numeric. Distance from the radar as measured along sea level
(down range), in m.}

\item{elev}{Numeric vector. Beam elevation(s), in degrees.}

\item{antenna}{Numeric. Height of the centre of the radar antenna, in m.}

\item{beam_angle}{Numeric. Beam opening angle in degrees, typically the
angle between the half-power (-3 dB) points of the main lobe.}

\item{k}{Numeric. Standard refraction coefficient.}

\item{lat}{Numeric. Geodetic latitude of the radar, in degrees.}

\item{re}{Numeric. Earth equatorial radius, in km.}

\item{rp}{Numeric. Earth polar radius, in km.}
}
\value{
Numeric vector. Normalized radiated energy at each of the specified
heights.
}
\description{
Calculates for a set of beam elevations (\code{elev}) the altitudinal normalized
distribution of radiated energy by those beams. Is a function of altitude
(\code{height}) at a given distance (\code{distance}) from the radar, assuming the
beams are emitted at antenna level
}
\details{
Beam profile is calculated using \link{beam_height} and
\link{beam_width}. Returns a beam profile as a function of height relative
to ground level.

Returns the normalized altitudinal pattern of radiated energy as a function
of altitude at a given distance from the radar, assuming the beams are
emitted at antenna level.
}
\examples{
# Plot the beam profile, for a 0.5 degree elevation beam at 50 km distance
# from the radar:
plot(beam_profile(height = 0:4000, 50000, 0.5), 0:4000,
  xlab = "normalized radiated energy",
  ylab = "height [m]", main = "beam elevation: 0.5 deg, distance=50km"
)

# Plot the beam profile, for a 2 degree elevation beam at 50 km distance
# from the radar:
plot(beam_profile(height = 0:4000, 50000, 2), 0:4000,
  xlab = "normalized radiated energy",
  ylab = "height [m]", main = "beam elevation: 2 deg, distance=50km"
)

# Plot the combined beam profile for a 0.5 and 2.0 degree elevation beam
# at 50 km distance from the radar:
plot(beam_profile(height = 0:4000, 50000, c(0.5, 2)), 0:4000,
  xlab = "normalized radiated energy",
  ylab = "height [m]", main = "beam elevations: 0.5,2 deg, distance=50km"
)
}
\seealso{
Other beam_functions: 
\code{\link{beam_distance}()},
\code{\link{beam_height}()},
\code{\link{beam_profile_overlap}()},
\code{\link{beam_range}()},
\code{\link{beam_width}()},
\code{\link{gaussian_beam_profile}()}
}
\concept{beam_functions}
