% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vp.R
\name{summary.vp}
\alias{summary.vp}
\alias{is.vp}
\alias{dim.vp}
\title{Inspect a vertical profile (\code{vp})}
\usage{
\method{summary}{vp}(object, ...)

is.vp(x)

\method{dim}{vp}(x)
}
\arguments{
\item{object}{A \code{vp} object.}

\item{...}{Additional arguments affecting the summary produced.}

\item{x}{A \code{vp} object.}
}
\value{
For \code{\link[=is.vp]{is.vp()}}: \code{TRUE} for an object of class \code{vp}, otherwise
\code{FALSE}.

For \code{\link[=dim.vp]{dim.vp()}}: number of heights and quantities in a vertical
profile (\code{vp}).
}
\description{
R base functions for inspecting a vertical profile of biological targets
(\code{vp}) object.
}
\details{
A vertical profile of biological targets contains a collection of quantities,
organized in different (typically equally spaced) altitude layers (height
bins) above the earth's surface. A vertical profile (\code{vp}) object is a list
containing:
\itemize{
\item \code{radar}: Radar identifier.
\item \code{datetime}: Nominal time of the volume to which the scan belongs in UTC.
\item \code{data}: A data.frame with the profile's quantities organized per height
bin. Use \code{\link[=get_quantity]{get_quantity()}} to access these:
\itemize{
\item \code{height}: Height bin (lower bound) in m above sea level.
\item \code{u}: Ground speed component west to east in m/s.
\item \code{v}: Ground speed component south to north in m/s.
\item \code{w}: Vertical speed (unreliable!) in m/s.
\item \code{ff}: Horizontal ground speed in m/s.
\item \code{dd}: Ground speed direction in degrees clockwise from north.
\item \code{sd_vvp}: VVP radial velocity standard deviation in m/s.
\item \code{gap}: Angular data gap detected in T/F.
\item \code{dbz}: Animal reflectivity factor in dBZ.
\item \code{eta}: Animal reflectivity in cm^2/km^3.
\item \code{dens}: Animal density in animals/km^3.
\item \code{DBZH}: Total reflectivity factor (bio + meteo scattering) in dBZ.
\item \code{n}: Number of data points used for the ground speed estimates
(quantities \code{u}, \code{v}, \code{w}, \code{ff}, \code{dd}).
\item \code{n_all}: Number of data points used for the radial velocity standard
deviation estimate (quantity \code{sd_vvp}).
\item \code{n_dbz}: Number of data points used for reflectivity-based estimates
(quantities \code{dbz}, \code{eta}, \code{dens}).
\item \code{n_dbz_all}: Number of data points used for the total reflectivity
estimate (quantity \code{DBZH}).
}
\item \code{attributes}: List of the vertical profile's \code{what}, \code{where} and \code{how}
attributes.
}
}
\section{Conventions}{

\itemize{
\item \code{NA}: Maps to \code{nodata} in the ODIM convention: value to denote areas void
of data (never radiated).
\item \code{NaN}: Maps to \code{undetect} in the ODIM convention: denote areas below the
measurement detection threshold (radiated but nothing detected). The value is
also used when there are too few datapoints to calculate a quantity.
\item \code{0}: Maps to \code{0} in the ODIM convention: denote areas where the quantity
has a measured value of zero (radiated and value zero detected or inferred).
}

It depends on a radar's detection threshold or signal to noise ratio whether
it safe to assume an \code{undetect} is equivalent to zero. When dealing with
close range data only (within 35 km), it is typically safe to assume aerial
densities (\code{dens}) and reflectivities (\code{eta}) are in fact zero in case of
undetects.
}

\examples{
# Check if an object is of class vp
is.vp(example_vp)

# Get summary info
example_vp # Same as summary(example_vp) or print(example_vp)

# Get dimensions
dim(example_vp)
}
\seealso{
\itemize{
\item \code{\link[=calculate_vp]{calculate_vp()}}
\item \code{\link[=read_vpfiles]{read_vpfiles()}}
\item \code{\link{example_vp}}
\item \code{\link[=get_quantity]{get_quantity()}}
\item \code{\link[=plot.vp]{plot.vp()}}
\item \code{\link[=as.data.frame.vp]{as.data.frame.vp()}}
\item \code{\link[=bind_into_vpts]{bind_into_vpts()}}
}
}
