% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_RSTD.R
\name{RSTD}
\alias{RSTD}
\title{Model: RSTD}
\usage{
RSTD(params)
}
\arguments{
\item{params}{[vector] algorithm packages accept only one argument}
}
\value{
[numeric] algorithm packages accept only one return
}
\description{
\deqn{V_{new} = V_{old} + \eta_{+} \cdot (R - V_{old}), R > V_{old}}
 \deqn{V_{new} = V_{old} + \eta_{-} \cdot (R - V_{old}), R < V_{old}}
}
\examples{
\dontrun{
RSTD <- function(params){

  res <- binaryRL::run_m(
    data = data,
    id = id,
    eta = c(params[1], params[2]),
    tau = c(params[3]),
    n_params = n_params,
    n_trials = n_trials,
    mode = mode
  )

  assign(x = "binaryRL.res", value = res, envir = binaryRL.env)

  switch(mode, "fit" = -res$ll, "simulate" = res, "replay" = res)
}
}
}
