% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_set_initial_value.R
\name{set_initial_value}
\alias{set_initial_value}
\title{Set initial values for all options}
\usage{
set_initial_value(data, options, initial_value = NA)
}
\arguments{
\item{data}{[data.frame] A data frame resulting from the 'step3' process of the `add_NA` function.}

\item{options}{[vector] all alternative options from 'step1' `unique_choice`}

\item{initial_value}{[numeric] subject's initial expected value for each 
stimulus's reward. If this value is not set (`initial_value = NA`), 
the subject will use the reward received after the first trial as the 
initial value for that stimulus. In other words, the learning rate for the 
first trial is 100%. default: `initial_value = NA` 
e.g., `initial_value = 0`}
}
\value{
data frame:
  \itemize{
    \item{\code{data}: step3 + row[0] with initial value.}
  }
}
\description{
Set initial values for all options
}
