% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_helpers.R
\name{bb_radarchart}
\alias{bb_radarchart}
\title{Helper for creating a radar chart}
\usage{
bb_radarchart(bb, data, mapping = NULL, ...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{data}{A \code{data.frame}, the first column will be used for x axis unless
specified otherwise in \code{mapping}. If not a \code{data.frame}, an object coercible to \code{data.frame}.}

\item{mapping}{Mapping of variables on the chart, see \code{\link{bbaes}}.}

\item{...}{Arguments passed to \code{\link{bb_radar}}.}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Helper for creating a radar chart
}
\examples{
library("billboarder")

# data about Avengers
data("avengers_wide")

# if not specified, first column is used as x-axis, 
# all others are used on y-axis
billboarder() \%>\%
  bb_radarchart(data = avengers_wide)

# specify explicitly which column to use with mapping
billboarder() \%>\%
  bb_radarchart(
    data = avengers_wide,
    mapping = bbaes(x = axis, y = `Captain America`)
  )


# with data in "long" format you can use "group" aesthetics
data("avengers")
billboarder() \%>\%
  bb_radarchart(
    data = avengers, 
    mapping = bbaes(x = axis, y = value, group = group)
  )
}
