% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_data.r
\name{filter.growing.season}
\alias{filter.growing.season}
\title{GPP-based Growing Season Filter}
\usage{
filter.growing.season(GPPd, tGPP, ws = 15, min.int = 5)
}
\arguments{
\item{GPPd}{daily GPP (any unit)}

\item{tGPP}{GPP threshold (fraction of 95th percentile of the GPP time series).
Takes values between 0 and 1.}

\item{ws}{window size used for GPP time series smoothing}

\item{min.int}{minimum time interval in days for a given state of growing season}
}
\value{
a vector of type integer of the same length as the input GPPd in which 0 indicate
        no growing season (dormant season) and 1 indicate growing season.
}
\description{
Filters annual time series for growing season based on smoothed daily GPP data.
}
\details{
The basic idea behind the growing season filter is that vegetation is 
         considered to be active when its carbon uptake (GPP) is above a specified 
         threshold, which is defined relative to the peak GPP (95th percentile) 
         observed in the year. 
         The GPP-threshold is calculated as:
         
         \deqn{GPP_threshold = quantile(GPPd,0.95)*tGPP}
         
         GPPd time series are smoothed with a moving average to avoid fluctuations 
         in the delineation of the growing season. The window size defaults to 15 
         days, but depending on the ecosystem, other values can be appropriate. 
         
         The argument \code{min.int} serves to avoid short fluctuations in the 
         status growing season vs. no growing season by defining a minimum length
         of the status. If a time interval shorter than \code{min.int} is labeled
         as growing season or non-growing season, it is changed to the status of 
         the neighboring values.
}
