% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigalgebra.R
\name{dgeqrf}
\alias{dgeqrf}
\title{QR factorization}
\usage{
dgeqrf(
  M = NULL,
  N = NULL,
  A,
  LDA = NULL,
  TAU = NULL,
  WORK = NULL,
  LWORK = NULL
)
}
\arguments{
\item{M}{an integer. The number of rows of the matrix A.  M >= 0.}

\item{N}{an integer. The number of columns of the matrix A.  N >= 0.}

\item{A}{the M-by-N big matrix A.}

\item{LDA}{an integer. The leading dimension of the array A.  LDA >= max(1,M).}

\item{TAU}{a min(M,N) matrix. The scalar factors of the elementary reflectors.}

\item{WORK}{a (MAX(1,LWORK)) matrix. On exit, if INFO = 0, WORK(1) returns the optimal LWORK.}

\item{LWORK}{an integer. The dimension of th array WORK.}
}
\value{
M-by-N big matrix A. The elements on and above the diagonal of the 
array contain the min(M,N)-by-N upper trapezoidal matrix R (R is upper 
triangular if m >= n); the elements below the diagonal, with the array TAU, 
represent the orthogonal matrix Q as a product of min(m,n) elementary 
reflectors.
}
\description{
DGEQRF computes a QR factorization of a real M-by-N matrix A: A = Q * R.
}
\examples{
\dontrun{
#' hilbert <- function(n) { i <- 1:n; 1 / outer(i - 1, i, "+") }
h9 <- hilbert(9); h9
qr(h9)$rank           #--> only 7
qrh9 <- qr(h9, tol = 1e-10)
qrh9$rank 
C <- as.big.matrix(h9)
dgeqrf(A=C)

# The big.matrix file backings will be deleted when garbage collected.
rm(C)
gc()
}
}
