% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isibib2df.R
\name{isibib2df}
\alias{isibib2df}
\title{Convert an ISI WoK Export file into a data frame}
\usage{
isibib2df(D)
}
\arguments{
\item{D}{is a character array containing data read from an ISI Export file (in bibtex format).}
}
\value{
a data frame with cases corresponding to articles and variables to Field Tag in the original SCOPUS file.
}
\description{
It converts an ISI WoK Export file and create a data frame from it, with cases corresponding to articles and variables to Field Tag in the original file.
}
\examples{
# A ISI Export file can be read using \\code{\\link{readLines}} function:

# largechar <- readLines('filename.bib')

# filename.bib is an ISI Export file in plain text format.
# The file have to be saved without Byte order mark (U+FEFF) at the
# beginning and EoF code at the end of file.
# The original file (exported by ISI search web site) can be modified
# using an advanced text editor like Notepad++ or Emacs.

# largechar <- readLines('http://www.bibliometrix.org/datasets/ranking.bib')

# ranking <- isibib2df(largechar)

}
\seealso{
\code{\link{isi2df}} for converting ISI Export file (in plain text format)

Other converting functions: \code{\link{convert2df}},
  \code{\link{isi2df}}, \code{\link{scopus2df}}
}
