% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{diagnostics}
\alias{diagnostics}
\title{Diagnostics Function for MCMC}
\usage{
diagnostics(object, ...)
}
\arguments{
\item{object}{an object of class \code{bhrcr}, given by \code{clearanceEstimatorBayes}.}

\item{...}{additional parameters.}
}
\value{
the directory location under which all the output is saved.
}
\description{
\code{diagnostics} provides diagnostic analysis for the MCMC process used in the main function 
\code{clearanceEstimatiorBayes}.
}
\details{
This function provides diagnostic analysis such as trace plots, ACF and PACF plots for some important parameters in the simulation process of Gibbs sampling.
With these diagnostic plots, we can be assured that we get the results after we have reached stationarity and have thinned sufficiently.
}
\examples{
\dontshow{
data("pursat")
data("pursat_covariates")
data = pursat[pursat["id"] <= 80 & pursat["id"] > 70,]
covariates = pursat_covariates[71:80,]
out <- clearanceEstimatorBayes(data = data, covariates = covariates, outlier.detect = TRUE,
                              niteration = 3, burnin = 1, thin = 1)
diagnostics(out)
}
\donttest{
data("posterior")
diagnostics(posterior)
}
\donttest{
data("pursat")
data("pursat_covariates")
out <- clearanceEstimatorBayes(data = pursat, covariates = pursat_covariates,
                               niteration = 200, burnin = 50, thin = 10)
diagnostics(out)
}
}
\author{
Colin B. Fogarty <cfogarty@mit.edu>, Saeed Sharifi-Malvajerdi <saeedsh@wharton.upenn.edu>, Feiyu Zhu <feiyuzhu@sas.upenn.edu>
}
