% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnalysisFunctions.R
\name{performAnalyses}
\alias{performAnalyses}
\title{performAnalyses}
\usage{
performAnalyses(
  scenario_list,
  evidence_levels = c(0.025, 0.05, 0.5, 0.8, 0.9, 0.95, 0.975),
  method_names = c("berry", "exnex", "exnex_adj", "pooled", "stratified"),
  target_rates = NULL,
  prior_parameters_list = NULL,
  calc_differences = NULL,
  n_mcmc_iterations = 10000,
  n_cores = parallel::detectCores() - 1L,
  seed = as.numeric(Sys.time()),
  verbose = TRUE
)
}
\arguments{
\item{scenario_list}{An object of class \code{scenario_list},
as e.g. created with \code{\link[bhmbasket]{simulateScenarios}}}

\item{evidence_levels}{A vector of numerics in \verb{(0, 1)} for the
\code{1-evidence_levels}-quantiles of the posterior response rates to be saved.
Default: \code{c(0.025, 0.05, 0.5, 0.8, 0.9, 0.95, 0.975)}}

\item{method_names}{A vector of strings for the names of the methods to be used. Must
be one of the default values, Default: \code{c("berry", "exnex", "exnex_adj", "pooled", "stratified")}}

\item{target_rates}{A vector of numerics in \verb{(0, 1)} for the
target rates of each cohort, Default: \code{NULL}}

\item{prior_parameters_list}{An object of class \code{prior_parameters_list},
as e.g. created with \code{\link[bhmbasket]{getPriorParameters}}}

\item{calc_differences}{A matrix of positive integers with 2 columns.
For each row the differences will be calculated.
Also a vector of positive integers can be provided for a single difference.
The integers are the numbers for the cohorts to be subtracted from one another.
E.g. providing \code{c(2, 1)} calculates the difference between cohort \code{2} and cohort \code{1}.
If \code{NULL}, no subtractions are performed, Default: \code{NULL}}

\item{n_mcmc_iterations}{A positive integer for the number of MCMC iterations,
Default: \code{10000}}

\item{n_cores}{A positive integer for the number of cores for the parallelization,
Default: \code{parallel::detectCores() - 1L}}

\item{seed}{A numeric for the random seed, Default: \code{as.numeric(Sys.time())}}

\item{verbose}{A logical indicating whether messages should be printed, Default: \code{TRUE}}
}
\value{
An object of class \code{analysis_list}.
}
\description{
This function performs the analysis of simulated or observed trial data with the
specified methods
and returns the quantiles of the posterior response rates
}
\details{
This function applies the following analysis models to (simulated) scenarios of class
\code{scenario_list}:
\itemize{
\item Bayesian hierarchical model (BHM) proposed by Berry et al. (2013): \code{"berry"}
\item BHM proposed by Neuenschwander et al. (2016): \code{"exnex"}
\item BHM that combines above approaches: \code{"exnex_adj"}
\item Pooled beta-binomial approach: \code{"pooled"}
\item Stratified beta-binomial approach: \code{"stratified"}
}
The posterior distributions of the BHMs are approximated with Markov chain Monte Carlo methods.
The MCMC methods are implemented in JAGS.
The JAGS code for the BHM \code{"exnex"} was taken from Neuenschwander et al. (2016).
The JAGS code for the BHM \code{"exnex_adj"} is based on the JAGS code for \code{"exnex"}.
}
\examples{
 trial_data <- createTrial(
   n_subjects   = c(10, 20, 30),
   n_responders = c(1, 2, 3))

 analysis_list <- performAnalyses(
   scenario_list      = trial_data,
   target_rates       = rep(0.5, 3),
   calc_differences   = matrix(c(3, 2, 1, 1), ncol = 2),
   n_mcmc_iterations  = 100,
   n_cores            = 1L)
}
\references{
Berry, Scott M., et al. "Bayesian hierarchical modeling of patient subpopulations:
efficient designs of phase II oncology clinical trials."
\emph{Clinical Trials} 10.5 (2013): 720-734.

Neuenschwander, Beat, et al. "Robust exchangeability designs
for early phase clinical trials with multiple strata."
\emph{Pharmaceutical statistics} 15.2 (2016): 123-134.

Plummer, Martyn. "JAGS: A program for analysis of Bayesian graphical models
using Gibbs sampling."
\emph{Proceedings of the 3rd international workshop on distributed statistical computing.}
Vol. 124. No. 125.10. 2003.
}
\seealso{
\code{\link[parallel]{detectCores}}
\code{\link[bhmbasket]{simulateScenarios}}
\code{\link[bhmbasket]{createTrial}}
\code{\link[bhmbasket]{getPriorParameters}}
}
\author{
Stephan Wojciekowski
}
