% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.bhetgp}
\alias{predict.bhetgp_vec}
\alias{predict.bhomgp}
\alias{predict.bhomgp_vec}
\title{Predict posterior mean and variance/covariance}
\usage{
\method{predict}{bhetgp}(
  object,
  x_new,
  lite = TRUE,
  return_all = FALSE,
  interval = c("pi", "ci", "both"),
  lam_ub = TRUE,
  cores = 1,
  samples = TRUE,
  ...
)

\method{predict}{bhetgp_vec}(
  object,
  x_new,
  lite = TRUE,
  return_all = FALSE,
  interval = c("pi", "ci", "both"),
  lam_ub = TRUE,
  vecchia = FALSE,
  m = object$m,
  ordering_new = NULL,
  cores = 1,
  samples = TRUE,
  ...
)

\method{predict}{bhomgp}(
  object,
  x_new,
  lite = TRUE,
  return_all = FALSE,
  interval = c("pi", "ci", "both"),
  cores = 1,
  samples = TRUE,
  ...
)

\method{predict}{bhomgp_vec}(
  object,
  x_new,
  lite = TRUE,
  return_all = FALSE,
  interval = c("pi", "ci", "both"),
  vecchia = FALSE,
  m = object$m,
  ordering_new = NULL,
  cores = 1,
  samples = TRUE,
  ...
)
}
\arguments{
\item{object}{object from \code{bhetGP} or \code{bhomGP}, 
with burn-in already removed}

\item{x_new}{matrix of predictive input locations}

\item{lite}{logical indicating whether to calculate only point-wise 
variances (\code{lite = TRUE}) or full covariance 
(\code{lite = FALSE})}

\item{return_all}{logical indicating whether to return mean and point-wise
variance prediction for ALL samples (only available for \code{lite = TRUE})}

\item{interval}{returns predictive variances by default \code{interval = "pi"}.
\code{interval = "ci"} returns variances for only mean process and 
\code{interval = "both"} returns both variances.}

\item{lam_ub}{logical uses upper 95 quantile for latent noise to 
obtain predictive variances for the response. If \code{lam_ub = FALSE},
the mean latent noise is used for inference.}

\item{cores}{number of cores to utilize for SNOW parallelization}

\item{samples}{logical indicating if you want all posterior samples returned 
including latent layer.}

\item{...}{N/A}

\item{vecchia}{logical uses vecchia approximation for prediction if \code{vecchia = TRUE}.}

\item{m}{size of Vecchia conditioning sets (only for fits with 
\code{vecchia = TRUE}), defaults to the \code{m} used for MCMC}

\item{ordering_new}{optional ordering for Vecchia approximation, must correspond
to rows of \code{x_new}, defaults to random, is applied to all layers
in deeper models.}
}
\value{
object of the same class with the following additional elements:
\itemize{
  \item \code{x_new}: copy of predictive input locations
  \item \code{m_pred}: size of predictive conditioning set if \code{vecchia = TRUE}
  \item \code{mean_y}: predicted posterior mean, indices correspond to 
        \code{x_new} locations
  \item \code{s2_y}: predicted point-wise variances, indices correspond to 
        \code{x_new} locations (only returned when \code{lite = TRUE} & 
        \code{interval = c("pi", "both")})
  \item \code{s2_y_ci}: predicted point-wise variances for the mean process, 
        indices correspond to \code{x_new} locations 
        (only returned when \code{lite = TRUE} & \code{interval = c("ci", "both")})
  \item \code{mean_all}: predicted posterior mean for each sample (column
        indices), only returned when \code{return_all = TRUE} 
  \item \code{s2_all} predicted point-wise variances each sample (column
        indices), only returned when \code{return-all = TRUE} & \code{interval = c("pi", "both")}
  \item \code{s2_all_ci} predicted point-wise variances for each sample (column
        indices), only returned when \code{return-all = TRUE} & \code{interval = c("ci", "both")}
  \item \code{Sigma}: predicted posterior covariance, indices correspond to 
        \code{x_new} locations (only returned when \code{lite = FALSE} 
        & \code{interval = c("pi", "both")})
  \item \code{Sigma_ci}: predicted posterior covariance for mean process, 
        indices correspond to \code{x_new} locations 
        (only returned when \code{lite = FALSE} & \code{interval = c("ci", "both")})
}
Additionally, if object belongs to class \code{bhetGP} or \code{bhetGP_vec}, the
log-noise process is also predicted for new locations \code{x_new}. The following are returned:
\itemize{
  \item \code{mean_lnugs}: predicted posterior mean for log noise process, 
        indices correspond to \code{x_new} locations
  \item \code{s2_lnugs}: predicted point-wise variances for log noise process, 
        indices correspond to \code{x_new} locations (only returned when 
        \code{lite = TRUE} & \code{interval = c("pi", "both")})
  \item \code{s2_lnugs_ci}: predicted point-wise variances for the log noise process, 
        indices correspond to \code{x_new} locations 
        (only returned when \code{lite = TRUE} & \code{interval = c("ci", "both")})
  \item \code{mean_lnugs_all}: predicted posterior mean for each sample for log 
        noise process (column indices), only returned when \code{return_all = TRUE} 
  \item \code{s2_lnugs_all} predicted point-wise variances each sample (column
        indices) for log noise process, only returned when \code{return-all = TRUE} 
        & \code{interval = c("pi", "both")}
  \item \code{s2_lnugs_all_ci} predicted point-wise variances for each sample (column
        indices) for log noise process, only returned when \code{return-all = TRUE} 
        & \code{interval = c("ci", "both")}
  \item \code{Sigma_lnugs}: predicted posterior covariance for log noise process, 
        indices correspond to \code{x_new} locations (only returned when \code{lite = FALSE} 
        & \code{interval = c("pi", "both")})
  \item \code{Sigma_lnugs_ci}: predicted posterior covariance for log noise process, 
        indices correspond to \code{x_new} locations 
        (only returned when \code{lite = FALSE} & \code{interval = c("ci", "both")})
 }
Computation time is added to the computation time of the existing object.
}
\description{
Acts on a \code{bhetgp}, \code{bhetgp_vec}, \code{bhomgp} or, 
    \code{bhomgp_vec} object. Calculates posterior mean and variance/covariance 
    over specified input locations. Optionally utilizes SNOW parallelization.
}
\details{
All iterations in the object are used for prediction, so samples 
    should be burned-in. Thinning the samples using \code{trim} will speed 
    up computation. Posterior moments are calculated using conditional 
    expectation and variance. As a default, only point-wise variance is 
    calculated. Full covariance may be calculated using \code{lite = FALSE}. 
    
    The posterior predictive variances are returned by default. The variance 
    for the mean process may be obtained by specifying \code{interval = "ci"}.
    \code{interval = "both"} will return both variances.
    
    SNOW parallelization reduces computation time but requires 
    more memory storage.
}
