% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgw_mle.R
\name{bgw_mle}
\alias{bgw_mle}
\title{bgw_mle}
\usage{
bgw_mle(calcR, betaStart, calcJ = NULL, bgw_settings = NULL)
}
\arguments{
\item{calcR}{Function that computes an n-vector (R) of model residuals for a p-vector of (numeric) parameters beta (the first argument). In this case the residuals are likelihoods (probabilities). (The beta vector can be named or unnamed.)}

\item{betaStart}{Vector of initial starting values for beta. Can be either a named or unnamed vector.}

\item{calcJ}{Function that computes the matrix of partial derivatives of R wrt beta (a.k.a. the Jacobian). If NULL, finite-difference derivatives are used. In matrix form, dim=c(p,n).  However, it could be stored as a vector in column-major order.}

\item{bgw_settings}{List. Contains control parameters for BGW estimation code. All parameters have default values, so user input is entirely optional.
               \itemize{
                 \item \strong{\code{printLevel}}: Integer (0-3). Controls the level of detail for iteration information written to the console during estimation.  0 = silent, 1 = print starting values and final solution only, 2 = short line summary, 3 = long line summary (see documentation). Default = 3.
                 \item \strong{\code{silent}}: Logical. Suppresses all output. Default = FALSE. (Currently redundant with printLevel = 0.)

                 \item \strong{\code{printNonDefaultSettings}}: Logical. Echos any user-provided bgw_settings. Default = TRUE.
                 \item \strong{\code{printStartingValues}}: Logical. Default = TRUE. Print starting values for beta.
                 \item \strong{\code{printFinalResults}}:  Logical. Default = TRUE. Print final status of estimation (convergence/error message), summary statistics (negative log-likelihood, iterations, function evals, etc.), beta, gradient, and (if available) estimated standard errors and t-ratios. (See vcHessianMethod for variance-covariance specification.)
                 \item \strong{\code{maxIterations}}: Numeric. Maximum number of iterations for the estimation. BGW default is 150.
                 \item \strong{\code{maxFunctionEvals}}: Numeric. Maximum number of objective function evaluations. BGW default is 200.
                 \item \strong{\code{modelName}}: Character. Used to create names for requested output files. Default is "bgw_mle_model."
                 \item \strong{\code{outputDirectory}}: Character. Name of sub-directory (~/outputDirectory) to write output files. Default is NULL (current directory).
                 \item \strong{\code{writeItSummary}}: Logical. If TRUE, iteration information is echoed in the output file "modelName_itSummary.csv". Default is FALSE. [Not currently implemented.]
                 \item \strong{\code{writeIter}}: Logical. If TRUE, parameters and log-likelihood for each iteration are written to "modelName_iterations.csv". Default is FALSE.
                 \item \strong{\code{vcHessianMethod}}: Character. Method for computing the Hessian approximation used for the variance-covariance matrix (VC = H^(-1)). Options are: "none","bhhh","finiteDifferences", or "fdFunction" ("finiteDifferences" automatically uses gradient differences if a gradient is available, otherwise it uses objective function differences. "fdFunction" allows the user to use objective function differences even if a gradient is available). Default is "bhhh."
                 \item \strong{\code{scalingMethod}}: Character. Method used to compute a scaling vector (scaleVec_i, i=1,..,p). Define a matrix D = diag(scaleVec_1,..., scaleVec_p). When using scaling, values in scaleVec should be chosen so that the elements of D*beta are roughly comparable in size. The re-scaled beta is used when computing trial steps using trust regions, and when computing stopping criteria. Options are: "adaptive," "none," and "userScaling": the default is "adaptive."  For a description of the "adaptive" method, which updates scaleVec at each iteration using information from the model Jacobian, see Bunch, Gay, and Welsch (1993). For "none," scaleVec is set to a p-vector of ones for the entire search. The "userScaling" option indicates that the user is supplying their own (fixed) scaleVec in bgw_settings[["userScaleVector"]] (see next item). Both items must be properly set or an error occurs.
                 \item \strong{\code{userScaleVector}}: Numeric, with dimension p = number of free parameters. Can be either a named or unnamed vector. This is a user-provided scaling vector that is used ONLY in conjunction with the non-default option "userScaling" for bgw_settings[["scalingMethod"]] (see previous item).
               }}
}
\value{
model object of class 'bgw_mle'. Output of a bgw maximum likelihood estimation procedure. A list with the following attributes:
\itemize{
\item \strong{\code{betaStart}}: Vector of initial starting values.
\item \strong{\code{bgw_settings}}: List. The same as the input argument.
\item \strong{\code{hasAnalyticGrad}}: Logical. Indicates in an analytical gradient calculation was used. If the user has not provided a calcJ function (see input parameter), it is set to FALSE.
\item \strong{\code{numParams}}: Numeric. Number of model parameters used in calcR.
\item \strong{\code{numResids}}: Numeric. Number of independent observations (model residuals) in data set = dimension of calcR output.
\item \strong{\code{code}}: Numeric. Numeric return code from BGW.
\item \strong{\code{message}}: Character. Message statement characterizing termination of MLE search.
\item \strong{\code{betaStop}}: Vector. Value of parameter vector at conclusion of MLE search. See message to determine if beta is a valid estimate.
\item \strong{\code{finalLL}}: Numeric. Value of log-likelihood at betaStop.
\item \strong{\code{iterations}}: Numeric. Number of iterations used in MLE search. In BGW, this is the same as the number of gradient evaluations.
\item \strong{\code{functionEvals}}: Numeric. Number of function evaluations used in MLE search. (This excludes function evaluations used by any finite-difference calculations for the gradient and/or the vcHessian.
\item \strong{\code{gradient}}: Vector. The gradient evaluated at betaStop.
\item \strong{\code{scaleVec}}: Vector. The scaling vector at the conclusion of the MLE search. Note: In the current version, this will be a p-vector of 1's (used throughout the search). In future versions, additional scaling options may be implemented.
\item \strong{\code{estimate}}: Vector. MLE parameter vector obtained by BGW. The same as betaStop if a valid convergence condition is achieved. Null otherwise.
\item \strong{\code{maximum}}: Numeric. Final log-likelihood value for a (successful) MLE search.
\item \strong{\code{hessianMethodAttempted}}: String. Requested method for computing vcHessian (from bgw_settings).
\item \strong{\code{hessianMethodUsed}}: String. Method actually used for computing vcHessian (if vcHessian was requested, and if the computation was successful. If not, a message indicating 'no request' or 'singular vcHessian' is provided.)
\item \strong{\code{vcHessianConditionNumber}}: Numeric. Estimated upper bound on reciprocal of Euclidean condition number of vcHessian (if available). Set to -1 if unavailable.
\item \strong{\code{varcovBGW}}: Matrix. p-by-p matrix containing estimate of the variance-covariance matrix (if requested and available).
\item \strong{\code{vcVec}}: Vector. Lower triangle of variance-covariance matrix stored in vector form (row-major order, if requested and available).
\item \strong{\code{seBGW}}: Vector. Estimated standard errors for parameter estimates (if requested and available).
\item \strong{\code{tstatBGW}}: Vector. Estimated t-statistics (versus 0, if requested and available).
}
}
\description{
Performs maximum likelihood estimation (MLE) for the user-provided model
defined in \code{bgw_calcR}.
}
\details{
This function has been written to provide an R-based interface to Fortran estimation software published in
Bunch, Gay and Welsch (1993), "Algorithm 717-Subroutines for Maximum Likelihood and Quasi-Likelihood
Estimation of Parameters in Nonlinear Regression Models," ACM Transactions on Mathematical Software, 19 (1),
March 1993, 109-130. The letters BGW will be used in various ways to denote the source of the
estimation functionality.

A primary motivation was to develop a more efficient maximum likelihood estimation function for use in
the Apollo choice modelling package: see \url{http://www.apollochoicemodelling.com/}. However, we
have adopted a design whereby the BGW package is wholly independent of Apollo, and can be
used in a stand-alone fashion. Note also that the BGW Fortran subroutines are written to support
general statistical estimation for an arbitrary objective/criterion function. So, although this
version of the package is specifically written for MLE, the package may see future updates that
expand the number of estimation options (for, e.g., nonlinear least squares, generalized method of
moments, etc.).

Remark: Following the convention in the numerical optimization literature, BGW minimizes the
objective function. That is, bgw_mle minimizes the negative-log-likelihood for the model calcR.
}
