% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{pcBinom}
\alias{pcBinom}
\title{Cumulative Probability Mass function for Lord's Two-Term Approximation to the Compound Binomial Distribution.}
\usage{
pcBinom(q, N, k, p, lower.tail = TRUE)
}
\arguments{
\item{q}{The quantile or vector of quantiles for which the proportion is to be calculated.}

\item{N}{Total number of trials.}

\item{k}{Lord's k (see documentation for the \code{Lords.k()} function).}

\item{p}{Probability of success for each trial.}

\item{lower.tail}{Logical. If TRUE (default), probabilities are P[X<x], otherwise, P[X >= x]. Note that this differs from base-R \code{binom()} functions.}
}
\description{
Function for calculating the proportion of observations up to a specifiable quantile under Lord's two-term approximation to the compound Binomial distribution.
}
\examples{
# Assume some variable follows a compound Binomial distribution with 100
# trials, a 50\% probability of success on each trial, and Lord's k = 1. To
# compute the cumulative probability at a specific point of the distribution
# (e.g., 50):
pcBinom(q = 50, N = 100, k = 1, p = .5)
}
