% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{qBeta.4P}
\alias{qBeta.4P}
\title{Quantile Given Probability Under the Four-Parameter Beta Probability Density Distribution.}
\usage{
qBeta.4P(p, l, u, alpha, beta, lt = TRUE)
}
\arguments{
\item{p}{A vector (or single value) of proportions or probabilities for which the corresponding value of x (i.e., the quantiles) are to be calculated.}

\item{l}{The first (lower) location parameter.}

\item{u}{The second (upper) location parameter.}

\item{alpha}{The first shape parameter.}

\item{beta}{The second shape parameter.}

\item{lt}{Whether the quantile(s) to be calculated is to be under the lower or upper tail. Default is TRUE (lower tail).}
}
\value{
A vector of quantiles for specified probabilities or proportions of observations under the four-parameter beta distribution.
}
\description{
Function for calculating the quantile (i.e., value of x) for a given proportion (i.e., the value of y) under the four-parameter beta distribution.
}
\examples{
# Assume some variable follows a four-parameter beta distribution with
# location parameters \\code{l = 0.25} and \\code{u = .75}, and shape
# parameters \\code{alpha = 5} and \\code{beta = 3}. To compute the
# quantile at a specific point of the distribution (e.g., .5)
# using \\code{qBeta.4P()}:
qBeta.4P(p = .5, l = .25, u = .75, alpha = 5, beta = 3)
}
