% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bsrr.R
\name{plot.bsrr}
\alias{plot.bsrr}
\title{Produces a coefficient profile plot of the coefficient or loss function
paths}
\usage{
\method{plot}{bsrr}(x, sign.lambda = 0, ...)
}
\arguments{
\item{x}{A \code{"bsrr"} object.}

\item{sign.lambda}{A logical value indicating whether to show lambda on log scale. Default is 0.}

\item{\dots}{Other graphical parameters to plot}
}
\value{
No return value, called for plots generation
}
\description{
Produces a coefficient profile plot of the coefficient or loss function
paths
}
\examples{

# Generate simulated data
n <- 200
p <- 20
k <- 5
rho <- 0.4
seed <- 10
Tbeta <- rep(0, p)
Tbeta[1:k*floor(p/k):floor(p/k)] <- rep(1, k)
Data <- gen.data(n, p, k, rho, family = "gaussian", beta = Tbeta, seed = seed)
lambda.list <- exp(seq(log(5), log(0.1), length.out = 10))
lm.bsrr <- bsrr(Data$x, Data$y, method = "pgsection")

# generate plots
plot(lm.bsrr)


}
\references{
Wen, C., Zhang, A., Quan, S. and Wang, X. (2020). BeSS: An R
Package for Best Subset Selection in Linear, Logistic and Cox Proportional
Hazards Models, \emph{Journal of Statistical Software}, Vol. 94(4).
doi:10.18637/jss.v094.i04.
}
\seealso{
\code{\link{bsrr}}.
}
\author{
Canhong Wen, Aijun Zhang, Shijie Quan, Liyuan Hu, Kangkang Jiang, Yanhang Zhang, Jin Zhu and Xueqin Wang.
}
