% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monthAxis.R
\name{monthAxis}
\alias{monthAxis}
\title{Label date axis}
\usage{
monthAxis(side = 1, time = NA, origin = "1970-01-01",
  mlabels = substr(month.abb, 1, 1), yformat = "\%Y", nmonths = 3,
  nym_half = 3.5, nym_none = 5, mcex = 0.7, ycex = 1,
  mtcl = par("tcl"), ytcl = par("tcl") - 1.7, mline = -1,
  yline = 0.2, las = 1, lrange = NA, trunc = NA, mgp = c(3, 1,
  0), mt = NULL, ml = NULL, yt = NULL, yl = NULL, quiet = FALSE,
  ...)
}
\arguments{
\item{side}{Which \code{\link{axis}} is to be labeled? DEFAULT: 1}

\item{time}{Logical indicating whether the axis is \code{\link{POSIXct}},
not \code{\link{Date}}. DEFAULT: NA, meaning axis value >1e5}

\item{origin}{Origin for\code{\link{as.Date}} and \code{\link{as.POSIXct}}.
DEFAULT: "1970-01-01"}

\item{mlabels}{Labels for the months. DEFAULT: J,F,M,A,M,J,J,A,S,O,N,D}

\item{yformat}{Format of year labels, see details in \code{\link{strptime}}.
Use \code{yformat=" "} (with space) to suppress year labeling.
DEFAULT: "\%Y"}

\item{nmonths}{Minimum number of months required before a year at the
axis boundary is labeled. DEFAULT: 3}

\item{nym_half}{Number of years on axis above which only every second month
is labeled. DEFAULT: 3.5}

\item{nym_none}{Number of years on axis above which the months are
not labeled. DEFAULT: 5}

\item{mcex}{\code{cex.axis} (letter size) for month labels. DEFAULT: 0.7}

\item{ycex}{\code{cex.axis} (letter size) for year labels. DEFAULT: 1}

\item{mtcl}{Month tick length (negative text line height units).
0 to suppress ticks. DEFAULT: par("tcl") = -0.5}

\item{ytcl}{Year tick length (negative text line height units).
0 to suppress ticks. DEFAULT: par("tcl")-1.7 = -2.2}

\item{mline}{Line of month labels. DEFAULT: -1}

\item{yline}{Line of year labels. DEFAULT: 0.2}

\item{las}{LabelAxisStyle for orientation of labels. DEFAULT: 1 (upright)}

\item{lrange}{Label range (two \code{\link{Date}} values).
DEFAULT: NA = internally computed from \code{\link{par}("usr")}}

\item{trunc}{Vector with two values: Number of days/seconds to truncate
at the left and right end of lrange. DEFAULT: NA}

\item{mgp}{MarGin Placement. Suggested not to change this, since
_tcl and _line defaults are chosen for the DEFAULT: c(3,1,0)}

\item{mt, ml, yt, yl}{Lists with further arguments passed to \code{\link{axis}},
like \code{lwd, col.ticks, lwd.ticks, hadj, lty}, separately
for month ticks, month labels, year ticks, year labels.
DEFAULT: NULL}

\item{quiet}{Suppress warning about short time axis? DEFAULT: FALSE}

\item{\dots}{Arguments passed to \code{\link{axis}} for all 4 elements.}
}
\value{
List with locations of month and year labels and ticks, each a Date vector.
}
\description{
Labels date axes at sensible monthly intervals in the
              time domain of years to decades.
}
\examples{

set.seed(007) # for reproducibility
timePlot <- function(nydays, start="2013-08-25", ...)
   plot(as.Date(start)+sort(c(0,sample(1:nydays, 50))),
        cumsum(rnorm(51)), type="l", xaxt="n", ann=FALSE, las=1, ...)

timePlot(1100)
monthAxis()
monthAxis(1, nmonths=6, col.axis="red") # 2013 not labeled anymore
monthAxis(side=3, nym_half=2) # if axis > 2 years, label only partially

timePlot(2e3)
monthAxis()   # long time series (>nym_none) only have years labeled
ma <- monthAxis(side=3, font=2)
abline(v=ma$mtics, col=8)
abline(v=ma$ytics)          # vertical lines in graph - now add lines/points


timePlot(900)
monthAxis(side=3, mtcl=0) # no tick lines between months
monthAxis(ycex=1.4, ytcl=2, lwd.ticks=2)
monthAxis(yline=1, col.axis=4, col=4)
monthAxis(mcex=1, col.axis="red", yformat=" ") # no years labeled
timePlot(900)
monthAxis(nmonths=1) # year labeled for short period as well

timePlot(800)
monthAxis()
monthAxis(mgp=c(2,1,0)) # the same. element 2 is relevant here
monthAxis(mgp=c(3,0,0)) # requires change in mline andy yline placement

timePlot(400)
ma <- monthAxis(lwd=3, yl=list(col.axis=3), mlabels=letters[1:12], mcex=1)
abline(v=ma$mtics, col=8) # use output from monthAxis for other functions

timePlot(80)
monthAxis(mlabels=month.abb, mcex=1) # short time series give a warning

timePlot(80, "2013-11-14")
monthAxis(mlabels=month.abb, mcex=1, nmonths=0, quiet=TRUE)

# Time axis instead of date axis:
plot(as.POSIXct(Sys.time()+c(0,2)*360*24*3600), 1:2, xaxt="n")
monthAxis(nmonths=2)

timePlot(800, "2015-01-01")
monthAxis()
timePlot(900, "2015-01-01", xaxs="i")
monthAxis()
timePlot(300, "2015-01-01", xaxs="i")
monthAxis() # if less than a full year is covered, the year label is centered

}
\seealso{
\code{\link{monthLabs}} for the numbercrunching itself,
         \code{\link{timeAxis}} for shorter or longer time frames,
         \code{\link{axis.Date}} with defaults that are less nice.
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Feb + Dec 2015, Oct 2017
}
\keyword{aplot}
\keyword{chron}
\keyword{dplot}
