% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_input_file.R
\name{create_beast2_input_file}
\alias{create_beast2_input_file}
\title{Create a BEAST2 input file}
\usage{
create_beast2_input_file(
  input_filename,
  output_filename,
  site_model = beautier::create_jc69_site_model(),
  clock_model = beautier::create_strict_clock_model(),
  tree_prior = beautier::create_yule_tree_prior(),
  mrca_prior = NA,
  mcmc = beautier::create_mcmc(),
  beauti_options = beautier::create_beauti_options(),
  tipdates_filename = NA
)
}
\arguments{
\item{input_filename}{A FASTA filename.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{output_filename}{Name of the XML parameter file created by this
function. BEAST2 uses this file as input.}

\item{site_model}{a site model,
as returned by \code{\link{create_site_model}}}

\item{clock_model}{a clock model,
as returned by \code{\link{create_clock_model}}}

\item{tree_prior}{a tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{mrca_prior}{a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{mcmc}{one MCMC.
Use \code{\link{create_mcmc}} to create an MCMC.
Use \code{\link{create_ns_mcmc}} to create an MCMC
  for a Nested Sampling run.
Use \code{\link{check_mcmc}} to check if an MCMC is valid.
Use \code{\link{rename_mcmc_filenames}} to rename the filenames in an MCMC.}

\item{beauti_options}{one BEAUti options object,
as returned by \code{\link{create_beauti_options}}}

\item{tipdates_filename}{name of the file containing the tip dates.
This file is assumed to have two columns, separated by a tab.
The first column contains the taxa names, the second column contains
the date.}
}
\value{
nothing
}
\description{
Create a BEAST2 input file
}
\examples{
if (is_on_ci()) {

  check_empty_beautier_folder()

  # Get an example FASTA file
  input_filename <- get_fasta_filename()

  # The file created by beautier, a BEAST2 input file
  output_filename <- get_beautier_tempfilename()

  create_beast2_input_file(
    input_filename,
    output_filename
  )
  file.remove(output_filename)

  remove_beautier_folder()
  check_empty_beautier_folder()
}
}
\seealso{
Use \link{create_beast2_input_file_from_model} to do the same with an
  inference model.
  See \code{\link{create_site_model}} for examples with
  different site models. See \code{\link{create_clock_model}} for examples
  with clock models. See \code{\link{create_tree_prior}} for examples with
  different tree priors. See \code{\link{create_mcmc}} for examples with
  a different MCMC setup.
}
\author{
Richèl J.C. Bilderbeek
}
