% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clock_model_to_xml_operators.R
\name{clock_model_to_xml_operators}
\alias{clock_model_to_xml_operators}
\title{Converts a clock model to the \code{operators} section of the
XML as text}
\usage{
clock_model_to_xml_operators(clock_model, mrca_priors, tipdates_filename = NA)
}
\arguments{
\item{clock_model}{a clock model,
as returned by \code{\link{create_clock_model}}}

\item{mrca_priors}{a list of one or more Most Recent Common Ancestor priors,
as returned by \code{\link{create_mrca_prior}}}

\item{tipdates_filename}{name of the file containing the tip dates.
This file is assumed to have two columns, separated by a tab.
The first column contains the taxa names, the second column contains
the date.}
}
\value{
a character vector of XML strings
}
\description{
Converts a clock model to the \code{operators} section of the
XML as text
}
\author{
Richèl J.C. Bilderbeek
}
