% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_distr.R
\name{is_laplace_distr}
\alias{is_laplace_distr}
\title{Determine if the object is a valid
Laplace distribution,
as created by \code{\link{create_laplace_distr}}}
\usage{
is_laplace_distr(x)
}
\arguments{
\item{x}{an object, to be determined if it is a valid
Laplace distribution}
}
\value{
TRUE if x is a valid Laplace distribution,
  FALSE otherwise
}
\description{
Determine if the object is a valid
Laplace distribution,
as created by \code{\link{create_laplace_distr}}
}
\examples{
library(testthat)

expect_true(is_laplace_distr(create_laplace_distr()))

expect_false(is_laplace_distr(create_log_normal_distr()))
expect_false(is_laplace_distr(NA))
expect_false(is_laplace_distr(NULL))
expect_false(is_laplace_distr("nonsense"))
}
\seealso{
use \code{\link{is_distr}} to see if x is any
  distribution
}
\author{
Richèl J.C. Bilderbeek
}
