% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_clock_models_from_names.R
\name{create_clock_models_from_names}
\alias{create_clock_models_from_names}
\title{Create clock models from their names}
\usage{
create_clock_models_from_names(clock_model_names)
}
\arguments{
\item{clock_model_names}{one or more names of a clock model,
must be name among those returned by \code{\link{get_clock_model_names}}}
}
\value{
a list of one or more clock models
}
\description{
Create clock models from their names
}
\examples{
  names <- get_clock_model_names()
  clock_models <- create_clock_models_from_names(names)

  for (i in seq_along(names)) {
    testthat::expect_equal(names[i], clock_models[[i]]$name)
  }
}
\seealso{
Use \link{create_clock_models} to get all clock models
}
\author{
Richèl J.C. Bilderbeek
}
