% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_phylo_crown_age.R
\name{get_phylo_crown_age}
\alias{get_phylo_crown_age}
\title{Obtain the crown age of a phylony}
\usage{
get_phylo_crown_age(phylogeny)
}
\arguments{
\item{phylogeny}{The phylogeny to obtain the crown age of}
}
\value{
the age of the phylogeny
}
\description{
Obtain the crown age of a phylony
}
\examples{
  phylogeny <- ape::read.tree(text = "(a:15,b:15):1;")
  created <- beautier:::get_phylo_crown_age(phylogeny = phylogeny)
  testit::assert(created == 15)
}
\author{
Richel J.C. Bilderbeek
}
