% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_run_cmd.R
\name{create_beast2_run_cmd}
\alias{create_beast2_run_cmd}
\title{Creates the terminal command to run BEAST2}
\usage{
create_beast2_run_cmd(
  input_filename,
  output_state_filename,
  rng_seed = NA,
  n_threads = NA,
  use_beagle = FALSE,
  overwrite = FALSE,
  beast2_path = get_default_beast2_path()
)
}
\arguments{
\item{input_filename}{the name of a BEAST2 input XML file.
This file usually has an \code{.xml} extension.
Use \link{create_temp_input_filename} to create a temporary
filename with that extension.}

\item{output_state_filename}{name of the BEAST2 output file that
stores the state
(usually has a \code{.xml.state} extension)}

\item{rng_seed}{the random number generator seed of the BEAST2 run.
Must be a non-zero positive integer value or \link{NA}.
If \code{rng_seed} is \link{NA}, BEAST2 will pick a random seed}

\item{n_threads}{the number of computational threads to use.
Use \link{NA} to use the BEAST2 default of 1.}

\item{use_beagle}{use BEAGLE if present}

\item{overwrite}{if TRUE: overwrite the \code{.log}
and \code{.trees} files if one of these exists.
If FALSE, BEAST2 will not be started if
\itemize{
  \item{the \code{.log} file exists}
  \item{the \code{.trees} files exist}
  \item{the \code{.log} file created by BEAST2 exists}
  \item{the \code{.trees} files created by BEAST2 exist}
}}

\item{beast2_path}{name of either a BEAST2 binary file
(usually simply \code{beast})
or a BEAST2 jar file
(usually has a \code{.jar} extension).
Use \link{get_default_beast2_bin_path} to get
the default BEAST binary file's path
Use \link{get_default_beast2_jar_path} to get
the default BEAST jar file's path}
}
\value{
a character vector with the command and
  arguments to call BEAST2
}
\description{
Creates the terminal command to run BEAST2
}
\examples{
  if (is_beast2_installed()) {
    cmds <- create_beast2_run_cmd(
      input_filename = "input.xml",
      output_state_filename = "output.xml.state",
      beast2_path = get_default_beast2_jar_path()
    )
    testit::assert(cmds[2] == "-cp")
  }
}
\author{
Richèl J.C. Bilderbeek
}
