% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_beast2.R
\name{run_beast2}
\alias{run_beast2}
\title{Run BEAST2}
\usage{
run_beast2(input_filename,
  output_log_filename = create_default_log_filename(input_filename,
  beast2_path, verbose),
  output_trees_filenames = create_default_trees_filenames(input_filename,
  beast2_path, verbose), output_state_filename = tempfile(pattern =
  "beastier_", fileext = ".xml.state"), rng_seed = NA, n_threads = NA,
  use_beagle = FALSE, overwrite = TRUE,
  beast2_working_dir = tempfile(pattern = "beast2_tmp_folder"),
  beast2_path = get_default_beast2_path(), verbose = FALSE)
}
\arguments{
\item{input_filename}{the name of a BEAST2 input XML file.
This file usually has an \code{.xml} extension.}

\item{output_log_filename}{name of the .log file to create}

\item{output_trees_filenames}{one or more names for .trees file to create.
There will be one .trees file created per alignment in the input
file. The number of alignments must equal the number of .trees
filenames, else an error is thrown. Alignments are sorted alphabetically
by their IDs}

\item{output_state_filename}{name of the .xml.state file to create}

\item{rng_seed}{the random number generator seed of the BEAST2 run.
Must be a non-zero positive integer value or \link{NA}.
If \code{rng_seed} is \link{NA}, BEAST2 will pick a random seed}

\item{n_threads}{the number of computational threads to use.
Use \link{NA} to use the BEAST2 default of 1.}

\item{use_beagle}{use BEAGLE if present}

\item{overwrite}{if TRUE: overwrite the \code{.log}
 and \code{.trees} files if one of these exists.
 If FALSE, BEAST2 will not be started if
 \itemize{
   \item{the \code{.log} file exists}
   \item{the \code{.trees} files exist}
   \item{the \code{.log} file created by BEAST2 exists}
   \item{the \code{.trees} files created by BEAST2 exist}
}}

\item{beast2_working_dir}{the folder BEAST2 will work in. This is
an (empty) temporary folder by default. This allows to call
BEAST2 in multiple parallel processes, as each process can have
its own working directory}

\item{beast2_path}{name of either a BEAST2 binary file
(usually simply \code{beast})
or a BEAST2 jar file
(usually has a \code{.jar} extension).
Use \link{get_default_beast2_bin_path} to get
the default BEAST binary file's path
Use \link{get_default_beast2_jar_path} to get
the default BEAST jar file's path}

\item{verbose}{if TRUE, additional information is displayed, that
is potentially useful in debugging}
}
\value{
The text sent to \code{STDOUT} and \code{STDERR}.
  It will create the files with names
  \code{output_log_filename}, \code{output_trees_filenames}
  and \code{output_state_filenames}
}
\description{
Run BEAST2
}
\examples{
library(testthat)

if (is_beast2_installed() && is_on_ci()) {

  output_log_filename <- tempfile(fileext = ".log")
  output_trees_filenames <- tempfile(fileext = ".trees")
  output_state_filename <- tempfile(fileext = ".xml.state")

  expect_false(file.exists(output_log_filename))
  expect_false(file.exists(output_trees_filenames))
  expect_false(file.exists(output_state_filename))

  output <- run_beast2(
    input_filename = get_beastier_path("2_4.xml"),
    output_log_filename = output_log_filename,
    output_trees_filenames = output_trees_filenames,
    output_state_filename = output_state_filename
  )

  expect_true(length(output) > 40)
  expect_true(file.exists(output_log_filename))
  expect_true(file.exists(output_trees_filenames))
  expect_true(file.exists(output_state_filename))
}
}
\author{
Richèl J.C. Bilderbeek
}
