% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{data_prep}
\alias{data_prep}
\title{Perform standardization of variables and prepears fixed effects estiamtion}
\usage{
data_prep(
  df,
  timestamp_col,
  entity_col,
  standardize = TRUE,
  entity_effects = FALSE,
  time_effects = FALSE,
  scale = TRUE
)
}
\arguments{
\item{df}{Dataframe with data that should be prepared for LIML estimation}

\item{timestamp_col}{Column with timestamps (e.g. years)}

\item{entity_col}{Column with entities (e.g. countries)}

\item{standardize}{Whether to standardize the data (by mean subtraction)}

\item{entity_effects}{Whether to introduce time cross-section effects
(by time demeaning)}

\item{time_effects}{Whether to introduce time fixed effects
(by cross-sectional demeaning)}

\item{scale}{Whether to divide by the standard deviation \code{TRUE} or not
\code{FALSE} during standardization. Default is \code{TRUE}}
}
\value{
A dataframe with standardized variables or/and prepared for fixed effects
estimation
}
\description{
This function performs
\href{https://en.wikipedia.org/wiki/Feature_scaling}{feature standarization}
(also known as z-score normalization), i.e. the features are centered around
the mean and scaled with standard deviation. Additionally, it allows introduction
of cross sectional and time fixed effects through demeaning.
}
\examples{
df <- data.frame(
  year = c(2000, 2001, 2002, 2003, 2004),
  country = c("A", "A", "B", "B", "C"),
  gdp = c(1, 2, 3, 4, 5),
  ish = c(2, 3, 4, 5, 6),
  sed = c(3, 4, 5, 6, 7)
)

data_prep(df, year, country, entity_effects = TRUE)

}
