% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GuessLanguagePipe.R
\name{GuessLanguagePipe}
\alias{GuessLanguagePipe}
\title{Class to guess the language of an Instance}
\description{
This class allows guess the language by using language detector of library
cld2. Creates the \strong{language} property which indicates the idiom text.
Optionally, it is possible to choose the language provided by Twitter.
}
\section{Details}{

To obtain the language of the tweets, it will be verified that there is a
json file with the information stored in memory. On the other hand, it is
necessary define the \strong{"cache.twitter.path"} field of
\emph{\link{bdpar.Options}} variable to know where the
information of tweets are saved.
}

\section{Note}{

The Pipe will invalidate the \code{\link{Instance}} if the language of the data
can not be detect.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{bdpar.Options}},
         \code{\link{ContractionPipe}}, \code{\link{File2Pipe}},
         \code{\link{FindEmojiPipe}}, \code{\link{FindEmoticonPipe}},
         \code{\link{FindHashtagPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{Instance}}, \code{\link{InterjectionPipe}},
         \code{\link{MeasureLengthPipe}}, \code{\link{GenericPipe}},
         \code{\link{SlangPipe}}, \code{\link{StopWordPipe}},
         \code{\link{StoreFileExtPipe}}, \code{\link{TargetAssigningPipe}},
         \code{\link{TeeCSVPipe}}, \code{\link{ToLowerCasePipe}}
}
\section{Super class}{
\code{\link[bdpar:GenericPipe]{bdpar::GenericPipe}} -> \code{GuessLanguagePipe}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{GuessLanguagePipe$new()}}
\item \href{#method-pipe}{\code{GuessLanguagePipe$pipe()}}
\item \href{#method-getLanguage}{\code{GuessLanguagePipe$getLanguage()}}
\item \href{#method-clone}{\code{GuessLanguagePipe$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getAlwaysBeforeDeps">}\href{../../bdpar/html/GenericPipe.html#method-getAlwaysBeforeDeps}{\code{bdpar::GenericPipe$getAlwaysBeforeDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getNotAfterDeps">}\href{../../bdpar/html/GenericPipe.html#method-getNotAfterDeps}{\code{bdpar::GenericPipe$getNotAfterDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getPropertyName">}\href{../../bdpar/html/GenericPipe.html#method-getPropertyName}{\code{bdpar::GenericPipe$getPropertyName()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="hash">}\href{../../bdpar/html/GenericPipe.html#method-hash}{\code{bdpar::GenericPipe$hash()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setAlwaysBeforeDeps">}\href{../../bdpar/html/GenericPipe.html#method-setAlwaysBeforeDeps}{\code{bdpar::GenericPipe$setAlwaysBeforeDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setNotAfterDeps">}\href{../../bdpar/html/GenericPipe.html#method-setNotAfterDeps}{\code{bdpar::GenericPipe$setNotAfterDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setPropertyName">}\href{../../bdpar/html/GenericPipe.html#method-setPropertyName}{\code{bdpar::GenericPipe$setPropertyName()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{GuessLanguagePipe}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuessLanguagePipe$new(
  propertyName = "language",
  alwaysBeforeDeps = list("StoreFileExtPipe", "TargetAssigningPipe"),
  notAfterDeps = list(),
  languageTwitter = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. Name of the property
associated with the \code{\link{GenericPipe}}.}

\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The dependencies
alwaysBefore (\code{\link{GenericPipe}s} that must be executed before
this one).}

\item{\code{notAfterDeps}}{A \code{\link{list}} value. The dependencies
notAfter (\code{\link{GenericPipe}s} that cannot be executed after
this one).}

\item{\code{languageTwitter}}{A \code{\link{logical}} value. Indicates whether
for the \code{\link{Instance}s} of type twtid the language that
returns the API is obtained or the detector is applied.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pipe"></a>}}
\if{latex}{\out{\hypertarget{method-pipe}{}}}
\subsection{Method \code{pipe()}}{
Preprocesses the \code{\link{Instance}} to obtain the
language of the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuessLanguagePipe$pipe(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} with the modifications that have
occurred in the pipe.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getLanguage"></a>}}
\if{latex}{\out{\hypertarget{method-getLanguage}{}}}
\subsection{Method \code{getLanguage()}}{
Guesses the language of data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuessLanguagePipe$getLanguage(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{\link{character}} value. The text to guess the ç
language.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The language guesser. Format: see ISO 639-3:2007.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GuessLanguagePipe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
