% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindUrlPipe.R
\name{FindUrlPipe}
\alias{FindUrlPipe}
\title{Class to find and/or remove the URLs on the data field of an Instance}
\description{
This class is responsible of detecting the existing URLs in the
\strong{data} field of each \code{\link{Instance}}. Identified URLs are
stored inside the \strong{URLs} field of \code{\link{Instance}} class.
Moreover if required, is able to perform inline URLs removement.
}
\section{Details}{

The regular expressions indicated in the \code{URLPatterns}
variable are used to identify URLs.
}

\section{Note}{

\code{\link{FindUrlPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{GenericPipe}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
\section{Super class}{
\code{\link[bdpar:GenericPipe]{bdpar::GenericPipe}} -> \code{FindUrlPipe}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URLPattern}}{A \code{\link{character}} value. The regular
expression to detect URLs.}

\item{\code{EmailPattern}}{A \code{\link{character}} value. The regular expression to detect emails.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FindUrlPipe$new()}}
\item \href{#method-pipe}{\code{FindUrlPipe$pipe()}}
\item \href{#method-findUrl}{\code{FindUrlPipe$findUrl()}}
\item \href{#method-removeUrl}{\code{FindUrlPipe$removeUrl()}}
\item \href{#method-putNamesURLPattern}{\code{FindUrlPipe$putNamesURLPattern()}}
\item \href{#method-getURLPatterns}{\code{FindUrlPipe$getURLPatterns()}}
\item \href{#method-setURLPatterns}{\code{FindUrlPipe$setURLPatterns()}}
\item \href{#method-getNamesURLPatterns}{\code{FindUrlPipe$getNamesURLPatterns()}}
\item \href{#method-setNamesURLPatterns}{\code{FindUrlPipe$setNamesURLPatterns()}}
\item \href{#method-clone}{\code{FindUrlPipe$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getAlwaysBeforeDeps">}\href{../../bdpar/html/GenericPipe.html#method-getAlwaysBeforeDeps}{\code{bdpar::GenericPipe$getAlwaysBeforeDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getNotAfterDeps">}\href{../../bdpar/html/GenericPipe.html#method-getNotAfterDeps}{\code{bdpar::GenericPipe$getNotAfterDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getPropertyName">}\href{../../bdpar/html/GenericPipe.html#method-getPropertyName}{\code{bdpar::GenericPipe$getPropertyName()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="hash">}\href{../../bdpar/html/GenericPipe.html#method-hash}{\code{bdpar::GenericPipe$hash()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setAlwaysBeforeDeps">}\href{../../bdpar/html/GenericPipe.html#method-setAlwaysBeforeDeps}{\code{bdpar::GenericPipe$setAlwaysBeforeDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setNotAfterDeps">}\href{../../bdpar/html/GenericPipe.html#method-setNotAfterDeps}{\code{bdpar::GenericPipe$setNotAfterDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setPropertyName">}\href{../../bdpar/html/GenericPipe.html#method-setPropertyName}{\code{bdpar::GenericPipe$setPropertyName()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{FindUrlPipe}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$new(
  propertyName = "URLs",
  alwaysBeforeDeps = list(),
  notAfterDeps = list("FindUrlPipe"),
  removeUrls = TRUE,
  URLPatterns = list(self$URLPattern, self$EmailPattern),
  namesURLPatterns = list("UrlPattern", "EmailPattern")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. Name of the property
associated with the \code{\link{GenericPipe}}.}

\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The dependencies
alwaysBefore (\code{\link{GenericPipe}s} that must be executed before
this one).}

\item{\code{notAfterDeps}}{A \code{\link{list}} value. The dependencies
notAfter (\code{\link{GenericPipe}s} that cannot be executed after
this one).}

\item{\code{removeUrls}}{A \code{\link{logical}} value. Indicates if the
URLs are removed.}

\item{\code{URLPatterns}}{A \code{\link{list}} value. The regex to find URLs.}

\item{\code{namesURLPatterns}}{A \code{\link{list}} value. The names of regex.}

\item{\code{propertyLanguageName}}{A \code{\link{character}} value. Name of the
language property.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pipe"></a>}}
\if{latex}{\out{\hypertarget{method-pipe}{}}}
\subsection{Method \code{pipe()}}{
Preprocesses the \code{\link{Instance}} to obtain/remove
the URLs. The URLs found in the data are added to the
list of properties of the \code{\link{Instance}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$pipe(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} with the modifications that have
occurred in the pipe.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-findUrl"></a>}}
\if{latex}{\out{\hypertarget{method-findUrl}{}}}
\subsection{Method \code{findUrl()}}{
Finds the \emph{URLs} in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$findUrl(pattern, data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pattern}}{A \code{\link{character}} value. The regex to find URLs.}

\item{\code{data}}{A \code{\link{character}} value. The text to find the URLs.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{list}} with URLs found.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-removeUrl"></a>}}
\if{latex}{\out{\hypertarget{method-removeUrl}{}}}
\subsection{Method \code{removeUrl()}}{
Removes \emph{the URL} in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$removeUrl(pattern, data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pattern}}{A \code{\link{character}} value. The regex to find URLs.}

\item{\code{data}}{A \code{\link{character}} value. The text to remove the URLs.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The data with URLs removed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-putNamesURLPattern"></a>}}
\if{latex}{\out{\hypertarget{method-putNamesURLPattern}{}}}
\subsection{Method \code{putNamesURLPattern()}}{
Sets the names to \emph{URL patterns} result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$putNamesURLPattern(resultOfURLPatterns)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resultOfURLPatterns}}{A \code{\link{list}} value. The list with
URLs found.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The URLs found with the names of URL pattern.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getURLPatterns"></a>}}
\if{latex}{\out{\hypertarget{method-getURLPatterns}{}}}
\subsection{Method \code{getURLPatterns()}}{
Gets \emph{the URL patterns}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$getURLPatterns()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of \emph{URL patterns}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setURLPatterns"></a>}}
\if{latex}{\out{\hypertarget{method-setURLPatterns}{}}}
\subsection{Method \code{setURLPatterns()}}{
Sets the \emph{URL patterns}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$setURLPatterns(URLPatterns)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{URLPatterns}}{A \code{\link{list}} value. The new value of
the URL patterns.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getNamesURLPatterns"></a>}}
\if{latex}{\out{\hypertarget{method-getNamesURLPatterns}{}}}
\subsection{Method \code{getNamesURLPatterns()}}{
Gets the \emph{names of URLs}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$getNamesURLPatterns()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of names of URLs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setNamesURLPatterns"></a>}}
\if{latex}{\out{\hypertarget{method-setNamesURLPatterns}{}}}
\subsection{Method \code{setNamesURLPatterns()}}{
Sets the \emph{names of URLs}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$setNamesURLPatterns(namesURLPatterns)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{namesURLPatterns}}{A \code{\link{list}} value. The new value of
the names of URLs.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
