% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindUrlPipe.R
\docType{class}
\name{FindUrlPipe}
\alias{FindUrlPipe}
\title{Class to find and/or remove the URLs on the data field of an Instance}
\usage{
FindUrlPipe
}
\description{
This class is responsible of detecting the existing URLs in the
\strong{data} field of each \code{\link{Instance}}. Identified URLs are
stored inside the \strong{URLs} field of \code{\link{Instance}} class.
Moreover if required, is able to perform inline URLs removement.
}
\section{Constructor}{

\preformatted{
FindUrlPipe$new(propertyName = "URLs",
                alwaysBeforeDeps = list(),
                notAfterDeps = list())
}

\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
}
}
}
}

\section{Details}{

The regular expressions indicated in the \code{URLPatterns}
variable are used to identify URLs.
}

\section{Note}{

\code{\link{FindUrlPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{PipeGeneric}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
preprocesses the \code{\link{Instance}} to obtain/remove the users.
\itemize{
\item{\emph{Usage:}}{

\preformatted{
pipe(instance,
     removeUrl = TRUE,
     URLPatterns = list(self$URLPattern, self$EmailPattern),
     namesURLPatterns = list("UrlPattern","EmailPattern"))}
}
\item{\emph{Value:}}{

the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
\item{\strong{removeUrl:}}{
(\emph{logical}) indicates if the URLs are removed.
}
\item{\strong{URLPatterns:}}{
(\emph{list}) the regex to find URLs.
}
\item{\strong{namesURLPatterns:}}{
(\emph{list}) the names of regex.
}
}
}
}
}

\item{\bold{findUrl:}}{
finds the URLs in the data.
\itemize{
\item{\emph{Usage:}}{
\code{findHashtag(pattern, data)}
}
\item{\emph{Value:}}{
list with URLs found.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{pattern:}}{
(\emph{character}) regex to find URLs.
}
\item{\strong{data:}}{
(\emph{character}) text to search the URLs.
}
}
}
}
}

\item{\bold{removeUrl:}}{
removes the URLs in the data.
\itemize{
\item{\emph{Usage:}}{
\code{removeUrl(pattern, data)}
}
\item{\emph{Value:}}{
the data with URLs removed.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{pattern:}}{
(character) regex to find URLs.
}
\item{\strong{data:}}{
(\emph{character}) text to remove the URLs.
}
}
}
}
}

\item{\bold{putNamesURLPattern:}}{
sets the names to URL patterns result.
\itemize{
\item{\emph{Usage:}}{
\code{putNamesURLPattern(resultOfURLPatterns)}
}
\item{\emph{Value:}}{
Value of \code{resultOfURLPatterns} variable with the names of URL pattern.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{resultOfURLPatterns:}}{
(\emph{list}) list with URLs found.
}
}
}
}
}

\item{\bold{getURLPatterns:}}{
gets of URL patterns.
\itemize{
\item{\emph{Usage:}}{
\code{getURLPatterns()}
}
\item{\emph{Value:}}{
value of URL patterns.
}
}
}

\item{\bold{getNamesURLPatterns:}}{
gets of name of URLs.
\itemize{
\item{\emph{Usage:}}{
\code{getNamesURLPatterns()}
}
\item{\emph{Value:}}{
value of name of URLs.
}
}
}

\item{\bold{setNamesURLPatterns:}}{
sets the name of URLs.
\itemize{
\item{\emph{Usage:}}{
\code{setNamesURLPatterns(namesURLPatterns)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{namesURLPatterns:}}{
(\emph{character}) the new value of the name of URLs.
}
}
}
}
}
}
}

\section{Public fields}{

\itemize{
\item{\bold{URLPattern:}}{
 (\emph{character}) regular expression to detect URLs.
}
\item{\bold{EmailPattern:}}{
 (\emph{character}) regular expression to detect emails.
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{URLPatterns:}}{
 (\emph{list}) regular expressions used to detect URLs.
}
\item{\bold{namesURLPatterns:}}{
 (\emph{list}) names of regular expressions that are used to identify URLs.
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{PipeGeneric}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
