% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate-indices.R
\name{generate_indices}
\alias{generate_indices}
\title{Generate regional annual indices of abundance continent and strata and optionally for countries, states/provinces, or BCRs from analyses run on the stratifications that support these composite regions}
\usage{
generate_indices(
  jags_mod = NULL,
  jags_data = NULL,
  quantiles = c(0.025, 0.05, 0.25, 0.75, 0.95, 0.975),
  regions = c("stratum", "continental"),
  alternate_n = "n",
  startyear = NULL,
  drop_exclude = FALSE,
  max_backcast = NULL,
  alt_region_names = NULL
)
}
\arguments{
\item{jags_mod}{JAGS list generated by \code{run_model}}

\item{jags_data}{data object used in \code{run_model}}

\item{quantiles}{vector of quantiles to be sampled from the posterior distribution Defaults to c(0.025,0.05,0.25,0.5,0.75,0.95,0.975)}

\item{regions}{vector selecting regional compilation(s) to calculate. Default is "continental","stratum", options also include "national", "prov_state", "bcr", and "bcr_by_country" for the stratifications that include areas that align with those regions.}

\item{alternate_n}{text string indicating the name of the alternative annual index parameter in a model, Default is "n"}

\item{startyear}{Optional first year for which to calculate the annual indices if a trajectory for only the more recent portion of the time series is desired. This is probably most relevant if max_backcast is set and so trajectories for different time-periods could include a different subset of strata (i.e., strata removed)}

\item{drop_exclude}{logical indicating if the strata that exceed the max_backcast threshold should be excluded from the calculations, Default is FALSE (regions are flagged and listed but not dropped)}

\item{max_backcast}{an optional integer indicating the maximum number of years to backcast the stratum-level estimates before the first year in which the species was observed on any route in that stratum. 5 is used in the CWS national estimates. If the observed data in a given stratum do not include at least one non-zero observation of the species between the first year of the BBS and startyear+max_backcast, the stratum is flagged within the relevant regional summary. Default value, NULL ignores any backcasting limit (i.e., generates annual indices for the entire time series, regardless of when the species was first observed)}

\item{alt_region_names}{Optional dataframe indicating the strata to include in a custom spatial summary. Generate the basic dataframe structure with the \code{extract_strata_areas} function, then modify with an additional column indicating the strata to include in a custom spatial summary}
}
\value{
List of 6 objects
  \item{data_summary}{dataframe with the following columns}
  \item{Year}{Year of particular index}
  \item{Region}{Region name}
  \item{Region_alt}{Long name for region}
  \item{Region_type}{Type of region including continental, national,Province_State,BCR, bcr_by_country, or stratum}
  \item{Strata_included}{Strata included in the annual index calculations}
  \item{Strata_excluded}{Strata potentially excluded from the annual index calculations because they have no observations of the species in the first part of the time series, see arguments max_backcast and startyear}
  \item{Index}{Strata-weighted count index}
  \item{additional columns for each of the values in quantiles}{quantiles of the posterior distribution}
  \item{obs_mean}{Mean of the observed annual counts of birds across all routes and all years. An alternative estimate of the average relative abundance of the species in the region and year. Differences between this and the annual indices are a function of the model. For composite regions (i.e., anything other than stratum-level estimates) this average count is calculated as an area-weighted average across all strata included}
  \item{nrts}{Number of BBS routes that contributed data for this species, region, and year}
  \item{nrts_total}{Number of BBS routes that contributed data for this species and region for all years in the selected time-series, i.e., all years since \code{startyear}}
  \item{nnzero}{Number of BBS routes on which this species was observed (i.e., count is > 0) in this region and year}
  \item{backcast_flag}{approximate annual average proportion of the covered species range that is free of extrapolated population trajectories. e.g., 1.0 = data cover full time-series, 0.75 = data cover 75 percent of time-series. Only calculated if max_backcast != NULL}

  \item{samples}{array of all posterior draws}
  \item{area-weights}{data frame of the strata names and area weights used to calculate the continental estimates}
  \item{y_min}{first year used in the summary, scale 1:length of time-series}
  \item{y_max}{last year used in the summary, scale 1:length of time-series}
  \item{startyear}{first year used in the summary, scale 1966:2018}
}
\description{
\code{generate_indices} creates a data frame of the annual indices
  of relative abundance by year. This data frame can then be used to
  plot population trajectories for the species, and to estimate trends.
}
\examples{

# Toy example with Pacific Wren sample data
# First, stratify the sample data

strat_data <- stratify(by = "bbs_cws", sample_data = TRUE)

# Prepare the stratified data for use in a JAGS model.
jags_data <- prepare_jags_data(strat_data = strat_data,
                               species_to_run = "Pacific Wren",
                               model = "firstdiff",
                               min_year = 2009,
                               max_year = 2018)

# Now run a JAGS model.
jags_mod <- run_model(jags_data = jags_data,
                      n_adapt = 0,
                      n_burnin = 0,
                      n_iter = 10,
                      n_thin = 1)

# Generate the continental and stratum indices
indices <- generate_indices(jags_mod = jags_mod,
                            jags_data = jags_data)

# Generate only national indices
indices_nat <- generate_indices(jags_mod = jags_mod,
                                jags_data = jags_data,
                                regions = c("national"))

}
