% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{rPosteriorPredictive.GaussianNIG}
\alias{rPosteriorPredictive.GaussianNIG}
\title{Generate random samples from the posterior predictive distribution of a "GaussianNIG" object}
\usage{
\method{rPosteriorPredictive}{GaussianNIG}(obj, n, X, ...)
}
\arguments{
\item{obj}{A "GaussianNIG" object.}

\item{n}{integer, number of samples.}

\item{X}{matrix, the location of the prediction, each row is a location.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A matrix of n rows and nrow(X) columns, each row is a sample.
}
\description{
Generate random samples from the posterior predictive distribution of the following structure:
   \deqn{x \sim Gaussian(X beta,sigma^2)}
   \deqn{sigma^2 \sim InvGamma(a,b)}
   \deqn{beta \sim Gaussian(m,sigma^2 V)}
Where X is a row vector, or a design matrix where each row is an obervation. InvGamma() is the Inverse-Gamma distribution, Gaussian() is the Gaussian distribution. See \code{?dInvGamma} and \code{dGaussian} for the definitions of these distribution.\cr
The model structure and prior parameters are stored in a "GaussianNIG" object. \cr
Posterior predictive is a distribution of x|m,V,a,b,X
}
\examples{
obj <- GaussianNIG(gamma=list(m=c(1,1),V=diag(2),a=1,b=1))
X <- matrix(runif(20),ncol=2)
rPosteriorPredictive(obj=obj,n=3,X=X)
}
\references{
Banerjee, Sudipto. "Bayesian Linear Model: Gory Details." Downloaded from http://www. biostat. umn. edu/ ph7440 (2008).
}
\seealso{
\code{\link{GaussianNIG}}, \code{\link{dPosteriorPredictive.GaussianNIG}}
}
