% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_qwCoalesce.R
\name{qwCoalesce}
\alias{qwCoalesce}
\title{Replace missing values}
\usage{
qwCoalesce(..., means = FALSE, lt.tol = 0.1)
}
\arguments{
\item{\dots}{any number of objects of class "qw." Missing values are permitted.}

\item{means}{logical, if \code{TRUE}, then compute the mean of all nonmissing
values in the data sepcified in \dots. if \code{FALSE}, then select the first 
nonmissing value the sequence spcified in \dots.}

\item{lt.tol}{an arbitrary tolerance metric to drop interval-censoring. See 
\code{\link{mean.qw}} for details.}
}
\value{
For \code{means} set to \code{FALSE}, an object of class "qw" in which each element 
is determined by selecting the first non-missing value in the order in which they are
specified in the argument list. The first step is to construct a matrix from
all arguments. The output is initially set to column 1; for any missing values
in the column, the data from column 2 are used and so on until all columns have
been searched or all missing values replaced. The metadata are set from the
corresponding column.

For \code{means} set to \code{FALSE}, an object of class "qw" computed from the 
mean of the nonmissing values in each row of the data specified in \dots.
The metadata, except for reporting limit information, are set from
the first entry in \dots.
}
\description{
Constructs a vector with as few missing values as possible from a selected
sequence of vectors.
}
\note{
This function is most useful for creating a column in a dataset from
related columns that represent different methods. For example, a single
column of alkalinity may be desired when there are multiple columns of
alkalinity determined by various methods.
}
\keyword{internal}
\keyword{manip}
