% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrBase_dectime2Date.R
\name{dectime2Date}
\alias{dectime2Date}
\title{Date Conversion}
\usage{
dectime2Date(x, Date.noon = TRUE)
}
\arguments{
\item{x}{the decimal date to convert.}

\item{Date.noon}{correct from noon correction for \code{dectime}.}
}
\value{
A vector of class "Date" corresponding to each value in \code{x}.
}
\description{
Convert time data expressed as year and fractional part of year to class "Date."
}
\details{
Added from smwrBase.
}
\note{
A small value, representing about 1 minute, is added to each value in \code{x}
to prevent truncation errors in the conversion. This can cause some errors if
the data were converted from date and time data.
}
\examples{

dectime("02/07/2013", date.format="\%m/\%d/\%Y")
# Convert back the printed result:
dectime2Date(2013.103)
}
\seealso{
\code{\link{dectime}}, \code{\link[base]{as.Date}}
}
\keyword{internal}
\keyword{manip}
