% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrGraphs_colorPlot.R
\docType{methods}
\name{colorPlot}
\alias{colorPlot}
\alias{colorPlot,numeric,numeric-method}
\alias{colorPlot,Date,numeric-method}
\alias{colorPlot,POSIXt,numeric-method}
\alias{colorPlot,numeric,numeric-method}
\alias{colorPlot,Date,numeric-method}
\alias{colorPlot,POSIXt,numeric-method}
\title{Plot Data}
\usage{
colorPlot(x, y, color, Plot = list(), yaxis.log = FALSE,
  yaxis.rev = FALSE, yaxis.range = c(NA, NA), xaxis.log = FALSE,
  xaxis.range = c(NA, NA), ylabels = 7, xlabels = 7, xtitle = "",
  ytitle = "", caption = "", margin = c(NA, NA, NA, NA), ...)

\S4method{colorPlot}{numeric,numeric}(x, y, color, Plot = list(name = "Auto",
  what = "points", symbol = "circle", filled = TRUE, size = 0.09, color =
  "Auto", groups = 4, ramp = "greenRed"), yaxis.log = FALSE,
  yaxis.rev = FALSE, yaxis.range = c(NA, NA), xaxis.log = FALSE,
  xaxis.range = c(NA, NA), ylabels = 7, xlabels = 7,
  xtitle = deparse(substitute(x)), ytitle = deparse(substitute(y)),
  caption = "", margin = c(NA, NA, NA, NA), ...)

\S4method{colorPlot}{Date,numeric}(x, y, color, Plot = list(name = "Auto",
  what = "lines", symbol = "circle", filled = TRUE, size = 0.09, color = "Auto",
  groups = 10, ramp = "greenRed"), yaxis.log = FALSE, yaxis.rev = FALSE,
  yaxis.range = c(NA, NA), xaxis.log = FALSE, xaxis.range = range(x, na.rm
  = TRUE), ylabels = 7, xlabels = "Auto", xtitle = "",
  ytitle = deparse(substitute(y)), caption = "", margin = c(NA, NA, NA,
  NA), ...)

\S4method{colorPlot}{POSIXt,numeric}(x, y, color, Plot = list(name = "Auto",
  what = "lines", symbol = "circle", filled = TRUE, size = 0.09, color = "Auto",
  groups = 10, ramp = "greenRed"), yaxis.log = FALSE, yaxis.rev = FALSE,
  yaxis.range = c(NA, NA), xaxis.log = FALSE, xaxis.range = range(x, na.rm
  = TRUE), ylabels = 7, xlabels = "Auto", xtitle = "",
  ytitle = deparse(substitute(y)), caption = "", margin = c(NA, NA, NA,
  NA), ...)
}
\arguments{
\item{x}{the x-axis data}

\item{y}{the y-axis data}

\item{color}{the colors or a class to set colors, must match the length of
\code{x} and \code{y}.}

\item{Plot}{tagged list of control parameters of the plot: \code{name}="Auto"
means derive class names from the argument color, otherwise, must be a tagged 
list of color=name, ... (in which case the color tag is not used); \code{what}
can be only "points" or "lines" in the current version; \code{color}="Auto"
means if the argument \code{color} is double or dateLike create groups of classes,
otherwise create unique colors, alternate values are "Range" (treat like double),
tagged list of group_name=color, and so forth, "Discrete" valid only for numeric, or
"Index" valid only for integer or for specified colors. No usable explanation
is generated when color is set to "Index"---use repeated calls to \code{addXY} if
an explanation is needed and specific colors are supplied.}

\item{yaxis.log}{logical, if \code{TRUE}, then log-transform the y axis}

\item{yaxis.rev}{logical, if \code{TRUE}, then reverse the y axis.}

\item{yaxis.range}{set the range of the y-axis. See \bold{Details}.}

\item{xaxis.log}{logical, if \code{TRUE}, then log-transform the x axis.}

\item{xaxis.range}{set the range of the x-axis. See \bold{Details}.}

\item{ylabels}{set up y-axis labels.}

\item{xlabels}{set up x-axis labels.}

\item{xtitle}{the x-axis title (also called x-axis caption).}

\item{ytitle}{the y-axis title (also called y-axis caption).}

\item{caption}{the figure caption.}

\item{margin}{set the plot area margins, in units of lines of text. Generally
all NA or the output from \code{setGraph} if appropriate.}

\item{...}{arguments for specific methods.}
}
\value{
Information about the graph.
}
\description{
Produces a line/scatter plot where each point or group of related points has a
unique color or where sections along a line have different colors.
}
\details{
For linear axes, the range can be set to virtually any pair of values. For 
log axes, the choice of range is more resticted---for less than one log-cycle,
powers of whole numbers can be used; from 1 to about 3 log cycles, the choces 
should be powers of 3 or 10; and for more than 3 log cycles, the range sould be 
expressed only in powers of 10.

Added from smwrGraphs.
}
\note{
A call should be made to \code{setPage} to set up the graphics
environment before calling \code{colorPlot}.
}
\section{Methods}{
 \describe{
\item{signature(x = "numeric", y = "numeric"))}{ Typically used to create a colored
scatter plot for numeric x and y data. }
\item{signature(x = "Date", y = "numeric")}{ Can be used to create a hydrograph
where the line is colored by a third variable, or a colored scatter plot over time. }
\item{signature(x = "POSIXt", y = "numeric")}{ Can be used to create a hydrograph
where the line is colored by a third variable, or a colored scatter plot over time. }
 }
}

\examples{
\dontrun{
set.seed(1)
X <- rnorm(32)
Y <- X + rnorm(32)
Z <- sqrt(X^2 + Y^2) # distance from origin
setGD()
# All defaults: color ramp from Z
colorPlot(X, Y, Z)
# See for examples of colorPlot:
vignette(topic="LineScatter", package="smwrGraphs")
}
}
\seealso{
\code{\link{setPage}}, \code{\link{xyPlot}}
}
\keyword{hplot}
\keyword{internal}
\keyword{methods}
