% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_gibbs_functions.R
\name{get_summary_stats}
\alias{get_summary_stats}
\title{Internal function that calculates the sufficient statistics for the
segmentation model}
\usage{
get_summary_stats(breakpt, dat, max.time, nbins, ndata.types)
}
\arguments{
\item{breakpt}{numeric. A vector of breakpoints.}

\item{dat}{A matrix that only contains columns storing discretized data for
each of the movement variables.}

\item{max.time}{numeric. The number of of the last observation of \code{dat}.}

\item{nbins}{numeric. A vector of the number of bins used to discretize each
movement variable. These must be in the same order as the columns within
\code{dat}.}

\item{ndata.types}{numeric. The length of \code{nbins}.}
}
\value{
Returns the sufficient statistics associated with the provided
  breakpoints for a given animal ID.
}
\description{
An internal function that calculates the sufficient statistics to be used
within the reversible-jump MCMC Gibbs sampler called by
\code{link{samp_move}}.
}
