% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.pmmh_output}
\alias{print.pmmh_output}
\title{Print method for PMMH output}
\usage{
\method{print}{pmmh_output}(x, ...)
}
\arguments{
\item{x}{An object of class `pmmh_output`.}

\item{...}{Additional arguments.}
}
\value{
The object `x` invisibly.
}
\description{
Print method for PMMH output
}
\examples{
# Create dummy chains for two parameters across two chains
chain1 <- data.frame(param1 = rnorm(100), param2 = rnorm(100), chain = 1)
chain2 <- data.frame(param1 = rnorm(100), param2 = rnorm(100), chain = 2)
dummy_output <- list(
  theta_chain = rbind(chain1, chain2),
  diagnostics = list(
    ess = c(param1 = 200, param2 = 190),
    rhat = c(param1 = 1.01, param2 = 1.00)
  )
)
class(dummy_output) <- "pmmh_output"
print(dummy_output)
}
