% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot3d.R
\name{barplot3d}
\alias{barplot3d}
\title{Adds a 3D bar plot to the current RGL scene}
\usage{
barplot3d(rows, cols, x, y, z, alpha = 1, scalexy = 1, gap = 0.2,
  topcolors = c("#000000"), sidecolors = c("#aaaaaa"),
  linecolors = c("#000000"), theta = 50, phi = 40,
  gridlines = TRUE, xlabels = FALSE, ylabels = FALSE,
  zlabels = TRUE, xsub = FALSE, ysub = FALSE, zsub = FALSE)
}
\arguments{
\item{rows}{How many rows the plotting area should have, an integer, e.g. 5.}

\item{cols}{How many columns the plotting area should have, an integer, e.g. 5.}

\item{x}{The x dimensions of each 3D bar, a vector of length 2 e.g. c(0,1).}

\item{y}{The y dimensions of each 3D bar, a vector of length 2 e.g. c(0,1).}

\item{z}{The height of each 3D bar, a numeric vector, e.g c(2,3,5,2,9).}

\item{alpha}{The alpha channel (transparency) of the sides of 3D bars. Range 0-1.}

\item{scalexy}{Scaling factor for x and y coordinates; this constant can be used to make the plot "skinnier" or "fatter".}

\item{gap}{Gap between 3D bars (recommended values are 0 or 0.2).}

\item{topcolors}{The color of the top of each 3D bar. Numeric vector of hexadecimal RGB colors, like those returned by rgb() e.g. "#078E53".}

\item{sidecolors}{The color of the top of the bar. Should be a hexadecimal RGB color, like that returned by rgb() e.g. "#aaaaaa".}

\item{linecolors}{The color of the edges of the bar. Should be a hexadecimal RGB color, like that returned by rgb() e.g. "#aaaaaa".}

\item{theta}{Polar coordinate for viewing the 3D barplot; range 0 to 360 (rotates the plot).}

\item{phi}{Polar coordinate for viewing the 3D barplot; range -90 to 90 (-90 is directly below, 90 directly above).}

\item{gridlines}{Draw gridlines on the plot (TRUE or FALSE).}

\item{xlabels}{Labels for the x axis (must be a vector of names the same length as "cols" parameter).}

\item{ylabels}{Labels for the y axis (must be a vector of names the same length as "rows" parameter).}

\item{zlabels}{Labels for the z axis; add numeric scale to the vertical dimension of the plot (TRUE or FALSE).}

\item{xsub}{Descriptive label for the x axis.}

\item{ysub}{Descriptive label for the y axis.}

\item{zsub}{Descriptive label for the z axis.}
}
\value{
Nothing is returned (invisibly returns NULL).
}
\description{
Adds a 3D bar plot to the current RGL scene
}
\examples{
\dontshow{
options(rgl.useNULL=TRUE)
}
barplot3d(rows=3,cols=5,z=1:12,topcolors=rainbow(12),alpha=0.7,scalexy=10,
xlabels=c("One","Two","Three","Four","Five"),ylabels=LETTERS[1:3])
}
