% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSprocessing.R
\name{GSprocessing}
\alias{GSprocessing}
\title{Prep GRAND-SLAM output for \code{bakRFnData}}
\usage{
GSprocessing(GS, use_symbol = FALSE)
}
\arguments{
\item{GS}{Table of read counts and NTR (fraction new) estimate parameters output by GRAND-SLAM. Corresponds
to the \emph{run_name}.tsv file included in GRAND-SLAM output}

\item{use_symbol}{Logical; if TRUE, then Symbol column rather than Gene column is used
as feature column (XF) in output data frame.}
}
\value{
A data frame that can be passed as the \code{fns} parameter to \code{bakRFnData}
}
\description{
This function creates a fraction new estimate data frame that can be passed to
\code{bakRFnData}, using main .tsv file output by GRAND-SLAM.
}
\examples{
# Load GRAND-SLAM table
data("GS_table")


# Create bakRData object
fns <- GSprocessing(GS_table)

}
