% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbt_delete_temp_files.R
\name{bbt_delete_temp_files}
\alias{bbt_delete_temp_files}
\title{Delete all the temporary files created by \link{bbt_run_from_model}}
\usage{
bbt_delete_temp_files(inference_model, beast2_options)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model,
as returned by \link[beautier]{create_inference_model}}

\item{beast2_options}{'BEAST2'  options,
as can be created by \link[beastier]{create_beast2_options}}
}
\description{
Delete all the temporary files created by \link{bbt_run_from_model}
}
\examples{
library(testthat)

if (is_beast2_installed()) {
  # Do a minimal run
  inference_model <- create_test_inference_model()
  beast2_options <- create_beast2_options()
  expect_silent(
    bbt_run_from_model(
      fasta_filename = get_fasta_filename(),
      inference_model = inference_model,
      beast2_options = beast2_options
    )
  )
  # Temporary files are created by 'bbt_run'
  expect_true(file.exists(inference_model$mcmc$tracelog$filename))
  expect_true(file.exists(inference_model$mcmc$treelog$filename))
  expect_true(file.exists(inference_model$mcmc$screenlog$filename))
  expect_true(file.exists(beast2_options$input_filename))
  expect_true(file.exists(beast2_options$output_state_filename))

  bbt_delete_temp_files(
    inference_model = inference_model,
    beast2_options = beast2_options
  )

  # Temporary files are deleted
  expect_false(file.exists(inference_model$mcmc$tracelog$filename))
  expect_false(file.exists(inference_model$mcmc$treelog$filename))
  expect_false(file.exists(inference_model$mcmc$screenlog$filename))
  expect_false(file.exists(beast2_options$input_filename))
  expect_false(file.exists(beast2_options$output_state_filename))
}
}
