% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default-credential.R
\name{get_token}
\alias{get_token}
\title{Get Authentication Token}
\usage{
get_token(
  scope = NULL,
  tenant_id = NULL,
  client_id = NULL,
  client_secret = NULL,
  use_cache = "disk",
  offline = FALSE,
  .chain = default_credential_chain(),
  .verbose = FALSE
)
}
\arguments{
\item{scope}{Optional character string specifying the authentication scope.}

\item{tenant_id}{Optional character string specifying the tenant ID for
authentication.}

\item{client_id}{Optional character string specifying the client ID for
authentication.}

\item{client_secret}{Optional character string specifying the client secret
for authentication.}

\item{use_cache}{Character string indicating the caching strategy. Defaults
to \code{"disk"}. Options include \code{"disk"} for disk-based caching or \code{"memory"}
for in-memory caching.}

\item{offline}{Logical. If \code{TRUE}, operates in offline mode. Defaults to
\code{FALSE}.}

\item{.chain}{A list of credential objects, where each element must inherit
from the \code{Credential} base class. Credentials are attempted in the order
provided until \code{get_token} succeeds.}

\item{.verbose}{Logical. If \code{TRUE}, prints detailed diagnostic information
during credential discovery and authentication. Defaults to \code{FALSE}.}
}
\value{
An \code{\link[httr2:oauth_token]{httr2::oauth_token()}} object.
}
\description{
Retrieves an authentication token using the default token provider. This is
a convenience function that combines credential discovery and token
acquisition in a single step.
}
\examples{
# In non-interactive sessions, this function will return an error if the
# environment is not setup with valid credentials. And in an interactive session
# the user will be prompted to attempt one of the interactive authentication flows.
\dontrun{
token <- get_token(
  scope = "https://graph.microsoft.com/.default",
  tenant_id = "my-tenant-id",
  client_id = "my-client-id",
  client_secret = "my-secret"
)
}

}
\seealso{
\code{\link[=get_token_provider]{get_token_provider()}}, \code{\link[=get_request_authorizer]{get_request_authorizer()}}
}
