% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3sync.R
\name{s3sync}
\alias{s3sync}
\title{S3 file sync}
\usage{
s3sync(files = dir(recursive = TRUE), bucket, verbose = TRUE, ...)
}
\arguments{
\item{files}{A character vector specifying relative paths to files to be synchronized. The default is all files in the working directory and subdirectories.}

\item{bucket}{Character string with the name of the bucket, or an object of class \dQuote{s3_bucket}.}

\item{verbose}{A logical indicating whether to be verbose (the default is \code{TRUE}).}

\item{\dots}{Additional arguments passed to \code{\link{s3HTTP}}.}
}
\value{
A logical.
}
\description{
Sync files/directories to/from S3
}
\details{
\code{s3sync} synchronizes specified files to an S3 bucket. This works best if a local directory (and its subdirectories) correspond directly to the contents of an S3 bucket.
If the bucket does not exist, it is created. Similarly, if local directories do not exist (corresponding to leading portions of object keys), they are created, recursively. Object keys are generated based on \code{files} and local files are named (and organized into directories) based on object keys. A slash is interpreted as a directory level.
Local objects are copied to S3 and S3 objects are copied locally. This copying is performed conditionally. Objects existing locally but not in S3 are uploaded using \code{\link{put_object}}. Objects existing in S3 but not locally, are saved using \code{\link{save_object}}. If objects exist in both places, the MD5 checksum for each is compared; when identical, no copying is performed. If the checksums differ, local files are replaced with the bucket version if the local file is older and the S3 object is replaced if the local file is newer. If checksums differ but modified times match (which seems unlikely), a warning is issued.
}
\examples{
\dontrun{
 s3sync(bucket = "examplebucket")
}

}
\references{
\href{http://docs.aws.amazon.com/cli/latest/reference/s3/sync.html}{aws s3 sync command line}
}
\seealso{
\code{\link{get_bucket}}, \code{\link{put_object}}, , \code{\link{save_object}}
}
