% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/put_key_material.R
\name{put_kms_material}
\alias{put_kms_material}
\alias{delete_kms_material}
\alias{get_material_parameters}
\title{Put/Delete KMS Key Material}
\usage{
put_kms_material(key, material, token, expires = TRUE, valid_to = NULL, ...)

delete_kms_material(key, ...)

get_material_parameters(key, algorithm = c("RSAES_PKCS1_V1_5",
  "RSAES_OAEP_SHA_1", "RSAES_OAEP_SHA_256"), spec = "RSA_2048", ...)
}
\arguments{
\item{key}{A character string specifying a key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with \dQuote{alias/}.}

\item{material}{A character string specifying the base64-encoded key material (encrypted according to parameters returned by \code{get_material_parameters}).}

\item{token}{A character string returned in \code{get_material_parameters()$ImportToken}.}

\item{expires}{Optionally, a logical indicating whether the key material expires. If \code{TRUE} (the default), \code{valid_to} is required.}

\item{valid_to}{Optionally (if \code{expires = TRUE}), a number specifying when the key material expires.}

\item{\dots}{Additional arguments passed to \code{\link{kmsHTTP}}.}

\item{algorithm}{A character string specifying an encryption algorithm used to encrypt the key material.}

\item{spec}{Ignored.}
}
\description{
Manage key material for \dQuote{external} keys.
}
\details{
\code{put_kms_material} adds key material to an \dQuote{external} KMS key, which can be created using \code{create_kms_key}. The import requires \code{delete_kms_material} deletes the imported material (but not the key itself).
}
\references{
\url{docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html}
}
\seealso{
\code{\link{create_kms_key}}
}
