% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_replace_route}
\alias{ec2_replace_route}
\title{Replace Route}
\usage{
ec2_replace_route(
  RouteTableId,
  DestinationCidrBlock = NULL,
  DestinationIpv6CidrBlock = NULL,
  DestinationPrefixListId = NULL,
  DryRun = NULL,
  VpcEndpointId = NULL,
  EgressOnlyInternetGatewayId = NULL,
  GatewayId = NULL,
  InstanceId = NULL,
  LocalTarget = NULL,
  NatGatewayId = NULL,
  TransitGatewayId = NULL,
  LocalGatewayId = NULL,
  CarrierGatewayId = NULL,
  NetworkInterfaceId = NULL,
  VpcPeeringConnectionId = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{RouteTableId}{String. The ID of the route table.}

\item{DestinationCidrBlock}{String. The IPv4 CIDR address block used for the destination match.[optional]}

\item{DestinationIpv6CidrBlock}{String. The IPv6 CIDR address block used for the destination match.[optional]}

\item{DestinationPrefixListId}{String. The ID of the prefix list for the route.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{VpcEndpointId}{String. The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.[optional]}

\item{EgressOnlyInternetGatewayId}{String. [IPv6 traffic only] The ID of an egress-only internet gateway.[optional]}

\item{GatewayId}{String. The ID of an internet gateway or virtual private gateway.[optional]}

\item{InstanceId}{String. The ID of a NAT instance in your VPC.[optional]}

\item{LocalTarget}{Logical. Specifies whether to reset the local route to its default target (\code{local}).[optional]}

\item{NatGatewayId}{String. [IPv4 traffic only] The ID of a NAT gateway.[optional]}

\item{TransitGatewayId}{String. The ID of a transit gateway.[optional]}

\item{LocalGatewayId}{String. The ID of the local gateway.[optional]}

\item{CarrierGatewayId}{String. [IPv4 traffic only] The ID of a carrier gateway.[optional]}

\item{NetworkInterfaceId}{String. The ID of a network interface.[optional]}

\item{VpcPeeringConnectionId}{String. The ID of a VPC peering connection.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Replace Route
}
\section{RouteTableId}{

The ID of the route
table.
}

\section{DestinationCidrBlock}{

The IPv4 CIDR address block used for the
destination match. The value that you provide must match the CIDR of an
existing route in the table.
}

\section{DestinationIpv6CidrBlock}{

The IPv6 CIDR address
block used for the destination match. The value that you provide must
match the CIDR of an existing route in the
table.
}

\section{DestinationPrefixListId}{

The ID of the prefix list for the
route.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{VpcEndpointId}{

The ID of a VPC endpoint.
Supported for Gateway Load Balancer endpoints
only.
}

\section{EgressOnlyInternetGatewayId}{

[IPv6 traffic only] The ID of an egress-only
internet gateway.
}

\section{GatewayId}{

The ID of an internet gateway or
virtual private gateway.
}

\section{InstanceId}{

The ID of a NAT instance in
your VPC.
}

\section{LocalTarget}{

Specifies whether to reset the local route
to its default target (\code{local}).
}

\section{NatGatewayId}{

[IPv4 traffic
only] The ID of a NAT gateway.
}

\section{TransitGatewayId}{

The ID of a transit
gateway.
}

\section{LocalGatewayId}{

The ID of the local
gateway.
}

\section{CarrierGatewayId}{

[IPv4 traffic only] The ID of a carrier
gateway.
}

\section{NetworkInterfaceId}{

The ID of a network
interface.
}

\section{VpcPeeringConnectionId}{

The ID of a VPC peering
connection.
}

