% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_volume_status}
\alias{ec2_describe_volume_status}
\title{Describe Volume Status}
\usage{
ec2_describe_volume_status(
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  VolumeId = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of volume results returned by \code{DescribeVolumeStatus} in paginated output.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{VolumeId}{List.   The IDs of the volumes.  Default: Describes all your volumes.  [optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describe Volume Status
}
\section{Filter}{


The filters.
\itemize{
\item \code{action.code} - The action code for the event (for example,
\code{enable-volume-io}).
\item \code{action.description} - A description of the action.
\item \code{action.event-id} - The event ID associated with the action.
\item \code{availability-zone} - The Availability Zone of the instance.
\item \code{event.description} - A description of the event.
\item \code{event.event-id} - The event ID.
\item \code{event.event-type} - The event type (for \code{io-enabled}: \code{passed} \|
\code{failed}; for \code{io-performance}: \code{io-performance:degraded} \|
\code{io-performance:severely-degraded} \| \code{io-performance:stalled}).
\item \code{event.not-after} - The latest end time for the event.
\item \code{event.not-before} - The earliest start time for the event.
\item \code{volume-status.details-name} - The cause for \code{volume-status.status}
(\code{io-enabled} \| \code{io-performance}).
\item \code{volume-status.details-status} - The status of
\code{volume-status.details-name} (for \code{io-enabled}: \code{passed} \|
\code{failed}; for \code{io-performance}: \code{normal} \| \code{degraded} \|
\code{severely-degraded} \| \code{stalled}).
\item \code{volume-status.status} - The status of the volume (\code{ok} \|
\code{impaired} \| \code{warning} \| \code{insufficient-data}).
}
}

\section{MaxResults}{

The maximum number of volume results returned by
\code{DescribeVolumeStatus} in paginated output. When this parameter is used,
the request only returns \code{MaxResults} results in a single page along
with a \code{NextToken} response element. The remaining results of the
initial request can be seen by sending another request with the returned
\code{NextToken} value. This value can be between 5 and 1,000; if
\code{MaxResults} is given a value larger than 1,000, only 1,000 results are
returned. If this parameter is not used, then \code{DescribeVolumeStatus}
returns all results. You cannot specify this parameter and the volume
IDs parameter in the same request.
}

\section{VolumeId}{


The IDs of the volumes.

Default: Describes all your volumes.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

