% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_placement_group}
\alias{ec2_create_placement_group}
\title{Create Placement Group}
\usage{
ec2_create_placement_group(
  DryRun = NULL,
  GroupName = NULL,
  Strategy = NULL,
  PartitionCount = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{GroupName}{String.   A name for the placement group.[optional]}

\item{Strategy}{String. The placement strategy.[optional]}

\item{PartitionCount}{Integer. The number of partitions. Valid only when \strong{Strategy} is set to \code{partition}.[optional]}

\item{TagSpecification}{List. The tags to apply to the new placement group.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Placement Group
}
\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{GroupName}{


A name for the placement group. Must be unique within the scope of your
account for the Region.

Constraints: Up to 255 ASCII characters
}

\section{Strategy}{

The placement strategy.
}

\section{PartitionCount}{

The
number of partitions. Valid only when \strong{Strategy} is set to
\code{partition}.
}

\section{TagSpecification}{

The tags to apply to the new placement
group.
}

